#include "test.h"
#include "chttp.h"

#define HHMAX 30

static HTLIB_ERROR err;
static HTLIB_Header hh[HHMAX];
static HTLIB_USHORT hhlen;
static int status;

static const char* id = NULL;

static BOOL
chkNoHeader(HTLIB_HANDLE h, const char* name)
{
	return checkNoHeader(h, hh, hhlen, id, name);
}
static BOOL
chkHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkHeader(h, hh, hhlen, id, name, value);
}
static BOOL
chkNotHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkNotHeader(h, hh, hhlen, id, name, value);
}
static char body[10000];

static int
recvBody(HTLIB_HANDLE h)
{
	return receiveBody(h, body, sizeof(body), id);
}

static BOOL
Send(int s, const void* buf, int len)
{
	if (len ==-1) {
		len = strlen(buf);
	}
	while (len>0) {
		int l = send(s, buf, len, MSG_NOSIGNAL);
		if (l==-1) {
			return FALSE;
		}
		len -= l;
		buf = ((char*)buf) + l;
	}
	return TRUE;
}
static void
test1(HTLIB_HANDLE h, const char* path)
{
	struct sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(8000);
	addr.sin_addr.s_addr = htonl(0x7f000001);
	if (HTLIB_Open(h, -1, (struct sockaddr*)&addr, sizeof(addr), &err)
		==FALSE) {
		FAIL(id, "Open");
		return;
	}
				
	if (Send(h->soc,
			 "GET http://localhost:8000/http11/abs1 HTTP/1.1\r\n"
			 "User-Agent: tcp/1.0\r\n"
			 "Host:\r\n"
			 "\r\n", -1)==FALSE) {
		FAIL(id, "Send");
		return;
	}

	h->_flags &= ~0x00013002;

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (len != 5) {
		FAIL(id, "len %d != 5", len);
		return;
	}
	if (memcmp(body, "absok", 5)!=0) {
		FAIL(id, "%.*s must be absok", 5, body);
		return;
	}
	SUCCEED(id);
}	
static void
test2(HTLIB_HANDLE h, const char* path)
{
	if (Send(h->soc,
			 "GET http://localhost:8000/http11/abs2 HTTP/1.1\r\n"
			 "User-Agent: tcp/1.0\r\n"
			 "Host: invalid\r\n"
			 "\r\n", -1)==FALSE) {
		FAIL(id, "Send");
		return;
	}

	h->_flags &= ~0x00013002;

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (len != 5) {
		FAIL(id, "len %d != 5", len);
		return;
	}
	if (memcmp(body, "absok", 5)!=0) {
		FAIL(id, "%.*s must be absok", 5, body);
		return;
	}
	SUCCEED(id);
}	

static void
test3(HTLIB_HANDLE h, const char* path)
{
	HTLIB_Header reqh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
		{ "Expect", "100-continue", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "POST", path,
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  NULL, -1, &err)==FALSE) {
		FAIL(id, "");
		return;
	}

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=100) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (HTLIB_SendBody(h, 2000, NULL, 5, &err)==FALSE) {
		FAIL(id, "SendBody", status);
		return;
	}
	if (HTLIB_SendBody(h, 2000, "12345", 5, &err)==FALSE) {
		FAIL(id, "SendBody", status);
		return;
	}
	if (HTLIB_SendBody(h, 2000, NULL, 5, &err)==FALSE) {
		FAIL(id, "SendBody", status);
		return;
	}
	if (HTLIB_SendBody(h, 2000, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBody", status);
		return;
	}
	if (HTLIB_SendBody(h, 2000, NULL, 0, &err)==FALSE) {
		FAIL(id, "SendBody", status);
		return;
	}

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Transfer-Encoding", "chunked")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=10) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return;
	}
	SUCCEED(id);
}	

static void
test4(HTLIB_HANDLE h, const char* path)
{
	const HTLIB_Header pp[] = {
		{ "param1", "100", 0, NULL},
	};
	const HTLIB_Header reqh[] = {
		{ "X-Param", "x", 1, pp },
	};

	int i;
	for (i=0; i<2; i++) {

		if (HTLIB_SendRequest(h, -1, "GET", path,
							  reqh, sizeof(reqh)/sizeof(reqh[0]),
							  NULL, 0, &err)==FALSE) {
			FAIL(id, "");
			return;
		}

		hhlen = HHMAX;
		if ((status=HTLIB_ReceiveResponse(h, 4000, hh, &hhlen, NULL,
										  &err))!=200) {
			FAIL(id, "status=%d", status);
			return;
		}

		if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
			return;
		}
		if (chkHeader(h, "Content-Length", "8")==FALSE) {
			return;
		}

		int len;
		if ((len=recvBody(h))!=8) {
			FAIL(id, "%d must be 8", len);
			return;
		}
		if (i==0) {
			if (chkNotHeader(h, "X-Seq", "1")==FALSE) {
				FAIL(id, "X-Seq %d must not be 1");
				return;
			}
			if (memcmp(body, "reconok1", len)!=0) {
				FAIL(id, "%.*s must be reconok1", len, body);
				return;
			}
		} else {
			if (chkHeader(h, "X-Seq", "1")==FALSE) {
				FAIL(id, "X-Seq %d must be 1");
				return;
			}
			if (memcmp(body, "reconok2", len)!=0) {
				FAIL(id, "%.*s must be reconok2", len, body);
				return;
			}
		}
		path = URLBASE "/http11/reconok2";
		sleep(1);
	}
	SUCCEED(id);
}	
static void
test5(HTLIB_HANDLE h, const char* path)
{
	const HTLIB_Header reqh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
	};

	int i;
	for (i=0; i<2; i++) {

		if (HTLIB_SendRequest(h, -1, "POST", path,
							  reqh, sizeof(reqh)/sizeof(reqh[0]),
							  "12345", 5, &err)==FALSE) {
			if (i==1&&err==HTLIB_E_SYSTEM) {
				SUCCEED(id);
				return;
			}
			FAIL(id, "");
			return;
		}

		hhlen = HHMAX;
		if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL,
										  &err))!=200) {
			FAIL(id, "status=%d", status);
			return;
		}

		if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
			return;
		}
		if (chkHeader(h, "Content-Length", "8")==FALSE) {
			return;
		}

		int len;
		if ((len=recvBody(h))!=8) {
			FAIL(id, "%d must be 8", len);
			return;
		}

		if (memcmp(body, "reconng1", len)!=0) {
			FAIL(id, "%.*s must be reconng1", len, body);
			return;
		}

		path = URLBASE "/http11/reconng2";
		sleep(1);
	}
	FAIL(id, "why?");
}	
static void
test6(HTLIB_HANDLE h, const char* path)
{
	const HTLIB_Header reqh[] = {
		//{ "Content-Type", "text/plain", 0, NULL },
	};

	int i;
	for (i=0; i<2; i++) {

		if (HTLIB_SendRequest(h, -1, "GET", path,
							  reqh, sizeof(reqh)/sizeof(reqh[0]),
							  NULL, 0, &err)==FALSE) {
			FAIL(id, "");
			return;
		}

		hhlen = HHMAX;
		if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL,
										  &err))!=200) {
			FAIL(id, "status=%d", status);
			return;
		}

		if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
			return;
		}
		if (chkHeader(h, "Content-Length", "6")==FALSE) {
			return;
		}

		int len;
		if ((len=recvBody(h))!=6) {
			FAIL(id, "%d must be 6", len);
			return;
		}

		if (memcmp(body, "crlfok", len)!=0) {
			FAIL(id, "%.*s must be crlfok", len, body);
			return;
		}

		int size = 6;
		while (size>0) {
			int len = 6-size;
			if ((len=send(h->soc, "\r\n\t\r\n "+len, size, MSG_NOSIGNAL)
				 )==-1) {
				FAIL(id, "can't send");
				return;
			}
			size -= len;
		}
	}
	SUCCEED(id);
}	
static void
test101(HTLIB_HANDLE h, const char* path)
{
	int i;
	for (i=0; i<3; i++) {
		switch (i) {
		case 0:
			if (Send(h->soc,
					 "GET /http10/keepalive1 HTTP/1.0\r\n"
					 "User-Agent: tcp/1.0\r\n"
					 "Connection: Keep-Alive\r\n"
					 "\r\n", -1)==FALSE) {
				FAIL(id, "Send");
				return;
			}

			h->_flags &= ~0x00013002;
			break;

		case 1:
			if (Send(h->soc,
					 "GET /http10/keepalive2 HTTP/1.0\r\n"
					 "User-Agent: tcp/1.0\r\n"
					 "\r\n", -1)==FALSE) {
				FAIL(id, "Send");
				return;
			}

			h->_flags &= ~0x00013002;
			break;

		case 2:
			if (HTLIB_SendRequest(h, -1, "GET", path, NULL, 0, NULL, 0,
								  &err)==FALSE) {
				FAIL(id, "SendRequest");
				return;
			}
			break;
		}
								  

		hhlen = HHMAX;
		if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL,
										  &err))!=200) {
			FAIL(id, "status=%d", status);
			return;
		}
		if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
			return;
		}
		if (chkHeader(h, "Content-Length", "9")==FALSE) {
			return;
		}
		if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
			return;
		}
		switch (i) {
		case 0:
			break;

		case 1:
			if (chkNotHeader(h, "X-Seq", "1")==FALSE) {
				return;
			}
			break;

		case 2:
			if (chkHeader(h, "X-Seq", "1")==FALSE) {
				return;
			}
			break;
		}
		int len;
		if ((len=recvBody(h))!=9) {
			FAIL(id, "%d must be 9", len);
			return;
		}
		if (memcmp(body, "keepalive", len)!=0) {
			FAIL(id, "%.*s must be keepalive", len, body);
			return;
		}
	}
	SUCCEED(id);
}	
static void
test091(HTLIB_HANDLE h, const char* path)
{
	if (Send(h->soc,
			 "GET /http09/get\r\n", -1)==FALSE) {
		FAIL(id, "Send");
		return;
	}

	int len;
	int index = 0;
	while ((len=recv(h->soc, body+index, sizeof(body)-index, 0))>0) {
		index += len;
		return;
	}
	if (len == -1) {
		FAIL(id, "recv %d", index);
		return;
	}
	if (memcmp(body, "http09", index)!=0) {
		FAIL(id, "%.*s must be http09", len, body);
		return;
	}
	SUCCEED(id);
}	

void
testHttp(HTLIB_HANDLE h)
{
	static struct {
		const char* id;
		const char* path;
		void(*func)(HTLIB_HANDLE, const char* path);
	} ff[] = {
		{ "H11-1(C)", URLBASE "/http11/abs1", test1 },
		{ "H11-2(C)", URLBASE "/http11/abs2", test2 },
		{ "H11-3(C)", URLBASE "/http11/100cont", test3 },
		{ "H11-4(C)", URLBASE "/http11/reconok1", test4 },
		{ "H11-5(C)", URLBASE "/http11/reconng1", test5 },
		{ "H11-6(C)", URLBASE "/http11/crlf", test6 },
		{ "H10-1(C)", URLBASE "/http10/keepalive", test101 },
		{ "H09-1(C)", URLBASE "/http09/get", test091 },
	};
	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		id = ff[i].id;
		printf("Test %s...\n", id);
		ff[i].func(h, ff[i].path);
	}
}

