#include "server.h"
#include "smisc.h"

static const char* id = NULL;

static BOOL
checkCommon(HTLIB_HANDLE h,
			HTLIB_Header* hh, short hlen, const char* ua)
{
	HTLIB_ERROR err = 0;
	
	if (ua == NULL) {
		ua = "testc/1.0";
	}
	int i;
	if ((i=HTLIB_Find(hh, hlen, "User-Agent"))==-1) {
		FAIL(id, "no User-Agent");
		return FALSE;
	}
	if (strcmp(hh[i].value, ua)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, ua);
		return FALSE;
	}
	return TRUE;
}
static BOOL
checkHost(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, const char* host)
{
	int i;
	HTLIB_ERROR err = 0;
	
	if (host == NULL) {
		host = "localhost:8000";
	}
	if ((i=HTLIB_Find(hh, hlen, "Host"))==-1) {
		FAIL(id, "no Host");
		return FALSE;
	}
	if (strcmp(hh[i].value, host)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, host);
		return FALSE;
	}
	return TRUE;
}

static BOOL
test1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, "tcp/1.0")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	int i;
	if ((i=HTLIB_Find(hh, hlen, "X-Data0"))==-1||
		hh[i].value[0] != 0) {
		FAIL(id, "X-Data0");
		return FALSE;
	}
	if ((i=HTLIB_Find(hh, hlen, "X-Data1"))==-1||
		strcmp(hh[i].value, "ver=1.0")!=0||
		hh[i].param_num != 3) {
		FAIL(id, "X-Data1");
		return FALSE;
	} else {
		const HTLIB_Header* pp = hh[i].param;
		if ((i=HTLIB_Find(pp, 3, "tag"))==-1||
			strcmp(pp[i].value, "1111")!=0||
			(i=HTLIB_Find(pp, 3, "ext1"))==-1||
			pp[i].value != NULL||
			(i=HTLIB_Find(pp, 3, "ext2"))==-1||
			strcmp(pp[i].value, "\"a\"")!=0) {
			FAIL(id, "X-Data1 param");
			return FALSE;
		}
	}
	if ((i=HTLIB_Find(hh, hlen, "X-Data2"))==-1||
		strcmp(hh[i].value, ";;;;")!=0) {
		FAIL(id, "X=Data2");
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	printf("sleep(1)...\n");
	sleep(1);
	
	if (HTLIB_SendResponse(h, -1, 999, NULL, &resh, 1, NULL, 5,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "index1", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

BOOL
testMisc(HTLIB_HANDLE h, const char* uri, const char* method,
		HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	static struct {
		const char* id;
		const char* path;
		BOOL(*func)(HTLIB_HANDLE, HTLIB_Header*, short hlen, int seq);
	} ff[] = {
		{ "MISC-1(S)", "/misc/", test1 },
	};

	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		if (strcmp(uri, ff[i].path)==0) {
			id = ff[i].id;
			if (strcmp(method, "GET")!=0) {
				FAIL(id, "%s must be GET", method);
				return FALSE;
			}
			return ff[i].func(h, hh, hlen, seq);
		}
	}

	FAIL("GET-X", "not implemented for %s", uri);
	return FALSE;
}

