#include "lnk.h"

int is_lnk( char* path )
{
	int length = strlen(path);

	if( length < 5 )
		return 0;

	if( path[ length - 4 ] == '.' &&
		path[ length - 3 ] == 'l' && path[ length - 2 ] == 'n'
		&& path[ length -1 ] == 'k')
	{
		return 1;
	}
	else
	{
	return 0;
	}
}

int read_string( char *buf , FILE *fp)
{
	int cnt = -1;
	int tmp_char;
	while(1)
	{	
		cnt++;
		tmp_char = fgetc( fp );

		if( tmp_char == EOF )
		{
			return LNK_READ_ERROR ;
		}

		if( tmp_char == '\0' )
		{
			buf[cnt] = tmp_char;
			break;
		}
		else
		{
			buf[cnt] = tmp_char;
		}
	}
	return 1;
}

int read_win_lnk( char* lnk_path , char* path_buffer)
{



	struct lnk_header_and_next_length header ; 
	int ret;
	char local_base_path[ MAXPATHLEN ];
	char final_path_name[ MAXPATHLEN ];
	char share_name[ MAXPATHLEN ];

	FILE * lnk_file;

	if((lnk_file = fopen( lnk_path , "rb")) == NULL )
	{
		return LNK_READ_ERROR ;
	}

	/*---------------------		Header	-----------------------	*/
	if( fread( &header, sizeof( header) , 1 , lnk_file ) < 0 )
	{
		fclose( lnk_file );
		return LNK_READ_ERROR ;
	}

	/*---------------		Item Id List( Skip )	--------------	*/
	if( header.header.flags & HAS_SHELL_ITEM_LIST )
	{
		if( fseek( lnk_file , ftell( lnk_file ) + header.next_length - sizeof( unsigned short ) , SEEK_SET ) != 0 )
		{
			fclose( lnk_file );
			return LNK_SEEK_ERROR ;
		}
	}
	else
	{
		if( fseek( lnk_file , ftell( lnk_file ) - sizeof( unsigned short ) , SEEK_SET ) != 0 )
		{
			fclose( lnk_file );
			return LNK_SEEK_ERROR ;
		}
	}

	/*---------------		File location info   	--------------	*/
	long base_position = ftell( lnk_file );

#ifdef DEBUG
	printf(" base_position : %d \n" , base_position );
#endif/*DEBUG*/

	struct file_location_info local_info ; 
	if( fread( &local_info , sizeof( local_info ) , 1 , lnk_file ) < 0 )
	{
		fclose( lnk_file );
		return LNK_READ_ERROR ;
	}

#ifdef DEBUG
	printf( "Total length %u, next %u, flags %u, vol offset %u, base offset %u,network offset %u, remaining %u\n",  
		local_info.total_length , /* This is the total length of this structure and all following data */
		local_info.first_following_offset , /*This is a pointer to first offset after this structure.*/
		local_info.flags , 
		local_info.local_volume_info_offset , /*Offset of local volume info*/
		local_info.base_pathname_offset , /* Offset of base pathname on local system */
		local_info.network_volume_info_offset , /* Offset of network volume info */
		local_info.remaining_pathname_offset /* Offset of remaining pathname */
		) ; 
#endif/*DEBUG*/


	/*------------------		  local_base_path   ----------------------*/
	if( local_info.flags & VOLUME_LOCAL || 
		local_info.flags & VOLUME_LOCAL_NETWORK ) {

			long local_base_pos = base_position + local_info.base_pathname_offset;

#ifdef DEBUG
			printf(" local_base_pos : %d \n" , local_base_pos );
#endif/*DEBUG*/

			if( fseek( lnk_file , local_base_pos , SEEK_SET ) != 0 )
			{
				fclose( lnk_file );
				return LNK_SEEK_ERROR ;
			}



			if( (ret = read_string( local_base_path , lnk_file )) < 0 )
			{
				fclose( lnk_file );
				return ret;
			}

#ifdef DEBUG
			printf(" local_base_path :%s \n" , local_base_path );
#endif/*DEBUG*/
		}


		/*------------------		  final_path_name   ----------------------*/
		long final_path_pos = 
			base_position + local_info.remaining_pathname_offset; 

#ifdef DEBUG
		printf(" final_path_pos : %d \n" , final_path_pos );
#endif/*DEBUG*/

		if( fseek( lnk_file , final_path_pos , SEEK_SET ) != 0 )
		{
			fclose( lnk_file );
			return LNK_SEEK_ERROR ;
		}


		if( (ret = read_string( final_path_name , lnk_file )) < 0 )
		{
			fclose( lnk_file );
			return ret;
		}

#ifdef DEBUG
		printf(" final_path_name :%s \n" , final_path_name );
#endif/*DEBUG*/

		/*------------------	 Network volume table   ----------------------*/
		if( local_info.flags & VOLUME_NETWORK
			|| local_info.flags & VOLUME_LOCAL_NETWORK )
		{
			long network_volume_pos
				= base_position + local_info.network_volume_info_offset;

#ifdef DEBUG
			printf(" network_volume_pos : %d \n" , network_volume_pos );
#endif/*DEBUG*/

			if( fseek( lnk_file , network_volume_pos , SEEK_SET ) != 0 )
			{
				fclose( lnk_file );
				return LNK_SEEK_ERROR ;
			}

			int network_table_size;
			if( fread( &network_table_size , sizeof( int ) , 1 , lnk_file ) < 0 )
			{
				fclose( lnk_file );
				return LNK_READ_ERROR ;
			}

			if( fseek( lnk_file , sizeof( int ) , SEEK_CUR ) != 0 )
			{
				fclose( lnk_file );
				return LNK_SEEK_ERROR ;
			}

			int share_name_offset;
			if( fread( &share_name_offset , sizeof( int ) , 1 , lnk_file ) < 0)
			{
				fclose( lnk_file );
				return LNK_READ_ERROR ;
			}

			int share_name_pos
				= network_volume_pos + share_name_offset;
			if( fseek( lnk_file , share_name_pos , SEEK_SET ) != 0 )
			{
				fclose( lnk_file );
				return LNK_SEEK_ERROR ;
			}


			if( fread( &share_name , network_table_size - share_name_offset , 1 , lnk_file ) <  0 )
			{
				fclose( lnk_file );
				return LNK_READ_ERROR ;
			}

#ifdef DEBUG
			printf(" share_name :%s \n" , share_name );
#endif/*DEBUG*/

		}/*if*/



		if( local_info.flags & VOLUME_LOCAL /*|| 
			local_info.flags & VOLUME_LOCAL_NETWORK*/ ) {

				sprintf( path_buffer , "%s%s" , local_base_path , final_path_name );



#ifdef DEBUG
				printf(" path_buffer :%s \n" , path_buffer );
#endif/*DEBUG*/

				fclose( lnk_file );
				return LNK_OK_ABSOLUTE_PATH ; 
			}
		else
		{
			long bit_dir = 0x1;
			bit_dir = bit_dir << 4;
			if( (header.header.file_attr & bit_dir ) == bit_dir )/* if dir */
			{
				strcpy( path_buffer , share_name );
			}
			else
			{
				sprintf( path_buffer , "%s\\%s" , share_name , final_path_name );
			}

#ifdef DEBUG
			printf(" path_buffer - network :%s \n" , path_buffer );
#endif/*DEBUG*/
			fclose( lnk_file );
			return LNK_OK_ABSOLUTE_PATH ;
		}


}/*proc*/


