// 2003/03/18 StringsConfig.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// stringsJeS[̐ݒ܂B
	/// </summary>
	public class StringsConfig : IConfig
	{

		#region ݒ荀
		string news_divider = 
			"_________________________________________________________";
		/// <summary>
		/// j[X̋؂
		/// </summary>
		[ValueType("Quote")]
		public string News_divider
		{
			get{return news_divider;}
			set
			{
				news_divider = Support.ProcessQuote( value );
			}
		}

		string news_time_format = "(%c):";
		/// <summary>
		/// j[X̎\̌`
		/// </summary>
		[ValueType("Quote")]
		public string News_time_format
		{
			get{return 	news_time_format;}
			set
			{
				news_time_format =  Support.ProcessQuote( value );
			}
		}

		string chat_format = "\r%13.13s:  %s";
		/// <summary>
		/// `bg̔\̌`
		/// </summary>
		[ValueType("Quote")]
		public string Chat_format
		{
			get{return chat_format;}
			set
			{
				chat_format = Support.ProcessQuote( value );
			}
		}

		string chat_opt_format = "\r *** %s %s";
		/// <summary>
		///  `bgIvV̔\̌`
		/// </summary>
		[ValueType("Quote")]
		public string Chat_opt_format
		{
			get{return chat_opt_format;}
			set
			{
				chat_opt_format = Support.ProcessQuote( value );
			}
		}
		#endregion

		public StringsConfig()
		{
		}


		public void Parse(Context context)
		{
			while(true)
			{
				string token = context.NextToken();
				if( token == null || token.Equals("}") )
				{
					break;
				}

				switch(token)
				{
					case"news_divider":
						this.News_divider = context.NextToken();
						break;

					case"news_time_format":
						this.News_time_format = context.NextToken();
						break;

					case"chat_format":
						this.Chat_format = context.NextToken();
						break;

					case"chat_opt_format":
						this.Chat_opt_format = context.NextToken();
						break;

					default:
						context.NextToken();
						break;
				}
			}
		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{
			ConfigWriter writer = new ConfigWriter( b );

			writer.StartCategory("strings");
			writer.WriteComment("dont change the number and order of the %");
			writer.WriteQuoteProperty( "news_divider" , this.News_divider );
			writer.WriteQuoteProperty( "news_time_format" , this.News_time_format );
			writer.WriteQuoteProperty( "chat_format" , this.Chat_format );
			writer.WriteQuoteProperty( "chat_opt_format" , this.Chat_opt_format );
			writer.EndCategory();
			
			return b;
		}
	}
}
