// 2003/03/18 SvGeneralPage.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace NTF.HXD.GUI.TabPage
{
	/// <summary>
	/// T[o[̑SʐݒŎgpRg[
	/// </summary>
	public class SvGeneralPage : System.Windows.Forms.UserControl , IConfigTabPage
	{

		#region Rg[
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.ComboBox versionCBox;
		private CtrlLib.NumEdit IP4Box;
		private CtrlLib.NumEdit IP3Box;
		private CtrlLib.NumEdit IP2Box;
		private CtrlLib.NumEdit IP1Box;
		private System.Windows.Forms.TextBox serverNameBox;
		private CtrlLib.NumEdit portNumberBox;
		#endregion

		Appli appli;
	

		public SvGeneralPage(Appli appli)
		{
			InitializeComponent();

			this.appli = appli;

			LoadConfig();
			this.Dock = DockStyle.Fill;
		}


		bool changed = false;
		public bool Changed
		{
			get{return changed;}
			set{changed = value;}
		}


		public void LoadConfig()
		{
			this.serverNameBox.Text	= appli.ServerConfig.TrackerConfig.Name;
			this.portNumberBox.Text	=	appli.ServerConfig.OptionsConfig.Port;

			uint version = uint.Parse(appli.ServerConfig.OptionsConfig.Version );
			if( version <= 123 )
			{
				this.versionCBox.SelectedIndex = 0;
			}
			else
			{
				this.versionCBox.SelectedIndex = 1;
			}

			string[] ip = appli.ServerConfig.OptionsConfig.Addresses.Split('.');

			if( ip.Length > 3 )
			{
				this.IP1Box.Text = ip[0];
				this.IP2Box.Text = ip[1];
				this.IP3Box.Text = ip[2];
				this.IP4Box.Text = ip[3];
			}

			changed = false;
		}


		public void SaveConfig()
		{
			appli.ServerConfig.TrackerConfig.Name	= this.serverNameBox.Text;
			appli.ServerConfig.OptionsConfig.Port	=	this.portNumberBox.Text;

			if( versionCBox.SelectedIndex > 0 )
			{
				this.appli.ServerConfig.OptionsConfig.Version = "185";
			}
			else
			{
				this.appli.ServerConfig.OptionsConfig.Version = "123";
			}

			appli.ServerConfig.OptionsConfig.Addresses = 
				this.IP1Box.Text + "." + this.IP2Box.Text + "." +
				this.IP3Box.Text + "." + this.IP4Box.Text;
		}


		#region Dispose
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion


		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.label15 = new System.Windows.Forms.Label();
			this.versionCBox = new System.Windows.Forms.ComboBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label9 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.IP4Box = new CtrlLib.NumEdit();
			this.IP3Box = new CtrlLib.NumEdit();
			this.IP2Box = new CtrlLib.NumEdit();
			this.IP1Box = new CtrlLib.NumEdit();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.serverNameBox = new System.Windows.Forms.TextBox();
			this.portNumberBox = new CtrlLib.NumEdit();
			this.label2 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// label15
			// 
			this.label15.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label15.Location = new System.Drawing.Point(12, 65);
			this.label15.Name = "label15";
			this.label15.Size = new System.Drawing.Size(90, 17);
			this.label15.TabIndex = 13;
			this.label15.Text = " : ";
			this.label15.Visible = false;
			// 
			// versionCBox
			// 
			this.versionCBox.Items.AddRange(new object[] {
																										 "Ver 1.2.3 Ƃē삳(tbgj[Xgp)",
																										 "Ver 1.8.5ȏƂē삳(Xbhj[Xƃtbgj[Xgp)"});
			this.versionCBox.Location = new System.Drawing.Point(109, 65);
			this.versionCBox.Name = "versionCBox";
			this.versionCBox.Size = new System.Drawing.Size(389, 20);
			this.versionCBox.TabIndex = 12;
			this.versionCBox.Visible = false;
			this.versionCBox.SelectedIndexChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																																						this.label9,
																																						this.label8,
																																						this.label7,
																																						this.label5,
																																						this.IP4Box,
																																						this.IP3Box,
																																						this.IP2Box,
																																						this.IP1Box,
																																						this.label4,
																																						this.label3});
			this.groupBox1.Location = new System.Drawing.Point(5, 148);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(573, 101);
			this.groupBox1.TabIndex = 11;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "T[o[IP";
			// 
			// label9
			// 
			this.label9.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label9.Location = new System.Drawing.Point(228, 88);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(5, 7);
			this.label9.TabIndex = 11;
			this.label9.Text = "E";
			this.label9.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label8
			// 
			this.label8.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label8.Location = new System.Drawing.Point(180, 88);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(3, 7);
			this.label8.TabIndex = 10;
			this.label8.Text = "E";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label7
			// 
			this.label7.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label7.Location = new System.Drawing.Point(132, 87);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(4, 7);
			this.label7.TabIndex = 9;
			this.label7.Text = "E";
			this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label5
			// 
			this.label5.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label5.Location = new System.Drawing.Point(10, 78);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(65, 19);
			this.label5.TabIndex = 7;
			this.label5.Text = "ServerIP : ";
			// 
			// IP4Box
			// 
			this.IP4Box.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.IP4Box.Location = new System.Drawing.Point(236, 75);
			this.IP4Box.Name = "IP4Box";
			this.IP4Box.Size = new System.Drawing.Size(34, 19);
			this.IP4Box.TabIndex = 6;
			this.IP4Box.Text = "0";
			this.IP4Box.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// IP3Box
			// 
			this.IP3Box.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.IP3Box.Location = new System.Drawing.Point(190, 75);
			this.IP3Box.Name = "IP3Box";
			this.IP3Box.Size = new System.Drawing.Size(34, 19);
			this.IP3Box.TabIndex = 5;
			this.IP3Box.Text = "0";
			this.IP3Box.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// IP2Box
			// 
			this.IP2Box.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.IP2Box.Location = new System.Drawing.Point(142, 75);
			this.IP2Box.Name = "IP2Box";
			this.IP2Box.Size = new System.Drawing.Size(34, 19);
			this.IP2Box.TabIndex = 4;
			this.IP2Box.Text = "0";
			this.IP2Box.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// IP1Box
			// 
			this.IP1Box.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.IP1Box.Location = new System.Drawing.Point(94, 75);
			this.IP1Box.Name = "IP1Box";
			this.IP1Box.Size = new System.Drawing.Size(34, 19);
			this.IP1Box.TabIndex = 3;
			this.IP1Box.Text = "0";
			this.IP1Box.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label4
			// 
			this.label4.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label4.Location = new System.Drawing.Point(9, 43);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(405, 24);
			this.label4.TabIndex = 1;
			this.label4.Text = "Ȃꍇ͂̂܂܂ɂĂĉB";
			// 
			// label3
			// 
			this.label3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label3.Location = new System.Drawing.Point(11, 20);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(405, 24);
			this.label3.TabIndex = 0;
			this.label3.Text = " multihoming/IP-Aliasing gpĂꍇ͈ȉɐݒ肵ĂB";
			// 
			// serverNameBox
			// 
			this.serverNameBox.Location = new System.Drawing.Point(109, 9);
			this.serverNameBox.Name = "serverNameBox";
			this.serverNameBox.Size = new System.Drawing.Size(181, 19);
			this.serverNameBox.TabIndex = 10;
			this.serverNameBox.Text = "name";
			this.serverNameBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// portNumberBox
			// 
			this.portNumberBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.portNumberBox.Location = new System.Drawing.Point(109, 36);
			this.portNumberBox.Name = "portNumberBox";
			this.portNumberBox.Size = new System.Drawing.Size(181, 19);
			this.portNumberBox.TabIndex = 9;
			this.portNumberBox.Text = "5500";
			this.portNumberBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label2
			// 
			this.label2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label2.Location = new System.Drawing.Point(10, 38);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(90, 17);
			this.label2.TabIndex = 8;
			this.label2.Text = "|[gԍ : ";
			// 
			// label1
			// 
			this.label1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label1.Location = new System.Drawing.Point(11, 13);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(90, 17);
			this.label1.TabIndex = 7;
			this.label1.Text = "T[o[̖O : ";
			// 
			// SvGeneralPage
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																																	this.label15,
																																	this.versionCBox,
																																	this.groupBox1,
																																	this.serverNameBox,
																																	this.portNumberBox,
																																	this.label2,
																																	this.label1});
			this.Name = "SvGeneralPage";
			this.Size = new System.Drawing.Size(584, 258);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void PropertyChanged(object sender, System.EventArgs e)
		{
			this.changed = true;
		}

	}
}
