/*!
  \file
  \brief GUI Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "GuiManager.h"
#include "ComponentInterface.h"
#include "LayerManager.h"
#include "ThreadCreator.h"
#include "LockGuard.h"
#include "SurfaceInterface.h"
#include "Delay.h"
#include "GetTicks.h"
#include "InputHandler.h"
#include "InputEvent.h"

using namespace beego;


struct GuiManager::pImpl {
  SDL_mutex* redraw_mutex;
  SurfaceList surface_list;
  LayerManager layer_manager;

  class ThreadArgs {
  public:
    SDL_mutex* mutex;
    LayerManager& layer_manager;
    SDL_Surface* scr;
    std::vector<SDL_Rect> update_rects;
    ComponentList component_list;
    SurfaceList& surface_list;
    InputEvent input_event;
    InputHandler input;

    ThreadArgs(SDL_mutex* mutex_obj, LayerManager& layer_manager_ref,
	       SurfaceList& surfaces)
      : mutex(mutex_obj), layer_manager(layer_manager_ref),
	scr(SDL_GetVideoSurface()), surface_list(surfaces) {
      //fprintf(stderr, "ThreadArgs mutex: %p\n", mutex);
    }
  };
  ThreadArgs thread_args;
  ThreadCreator thread;

  pImpl(void) : redraw_mutex(SDL_CreateMutex()), layer_manager(surface_list),
		thread_args(redraw_mutex, layer_manager, surface_list),
		thread(update_thread, &thread_args) {
    //fprintf(stderr, "pImpl redraw_mutex: %p\n", redraw_mutex);
    thread.run();
  }

  ~pImpl(void) {
    thread.wait();
    //LockMutex(mutex);
    // !!! L̎ƁA
    // *** glibc detected *** corrupted double-linked list: 0xb7dab858 ***
    // Abort
    // ɂȂ𗝉ׂ

    SDL_DestroyMutex(redraw_mutex);

    // !!! Layer  remove ׂ
  }

  static int update_thread(void* args) {
    ThreadArgs* data = static_cast<ThreadArgs*>(args);
    //fprintf(stderr, "data->mutex: %p\n", data->mutex);

    delay(1);

    // !!! AVXeɓo^ ticks g悤ɕύXBKvɉ
    size_t ticks = GetTicks();

    // T[tFXXg̍č\z
    LockMutex(data->mutex);
    //fprintf(stderr, "at GuiManager::pImpl::update_thread\n");
    data->layer_manager.createComponentList(data->component_list);
    data->layer_manager.createSurfaceList(data->surface_list,
					  data->component_list, ticks);

    // ̓Cxg̔f
    data->input.updateInputEvent(data->input_event);
    data->layer_manager.applyInput(data->component_list, data->input_event);

    // ĕ`
    data->update_rects.clear();
    data->layer_manager.redraw(data->update_rects, data->surface_list, 0);
    //UnlockMutex(data->mutex);

    SDL_UpdateRects(data->scr,
		    data->update_rects.size(), &data->update_rects[0]);

    //fprintf(stderr, "at GuiManager::pImpl::update_thread\n");
    UnlockMutex(data->mutex);

    // !!! AIȕ`ۏ؂dg݂ɒu

    return 0;
  }
};


GuiManager::GuiManager(void) : pimpl(new pImpl) {
}


GuiManager::~GuiManager(void) {
}


SDL_mutex* GuiManager::getMutex(void) {
  //fprintf(stderr, "pImpl redraw_mutex: %p\n", pimpl->redraw_mutex);
  return pimpl->redraw_mutex;
}


/*!
  \brief ĕ`~

  \attention ̃\bhĂ΂ GuiManager jƁA
*/
void GuiManager::stop(void) {
  pimpl->thread.wait();
}


void GuiManager::push_front(Layer* layer) {
  LockGuard guard(pimpl->redraw_mutex);
  pimpl->layer_manager.push_front(layer);
}


void GuiManager::push_back(Layer* layer) {
  LockGuard guard(pimpl->redraw_mutex);
  pimpl->layer_manager.push_back(layer);
}


void GuiManager::insert(const Layer* dst, Layer* layer) {
  LockGuard guard(pimpl->redraw_mutex);
  pimpl->layer_manager.insert(dst, layer);
}


void GuiManager::remove(Layer* layer) {
  LockGuard guard(pimpl->redraw_mutex);
  pimpl->layer_manager.remove(layer);
}
