#ifndef GUI_MANAGER_H
#define GUI_MANAGER_H

/*!
  \file
  \brief GUI Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <SDL.h>
#include <memory>

namespace beego {
  class Layer;

  class GuiManager {
    GuiManager(const GuiManager& rhs);
    GuiManager& operator = (const GuiManager& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    GuiManager(void);
    ~GuiManager(void);
    SDL_mutex* getMutex(void);

    void stop(void);

    void push_front(Layer* layer);
    void push_back(Layer* layer);
    void insert(const Layer* dst, Layer* layer);
    void remove(Layer* layer);
    //size_t getRedrawTimes(void);
  };
};

#endif /* !GUI_MANAGER_H */
