/*!
  \file
  \brief j[R|[lg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "GridTypes.h"
#include "SdlUtils.h"
#include "Component.h"
#include "InputEvent.h"

using namespace beego;


struct MenuComponent::pImpl {
  size_t width;
  size_t height;
  int selected_index;
  int decided_index;

  class MenuItem {
  public:
    boost::shared_ptr<ButtonComponent> button;
    Grid<int> offset;
    SDL_Rect position;

    MenuItem(boost::shared_ptr<ButtonComponent> button_obj,
	     int x_offset, int y_offset)
      : button(button_obj), offset(Grid<int>(x_offset, y_offset)) {
      set_SdlRect(&position, 0, 0);
    }
  };
  std::vector<MenuItem> items;
  SDL_Rect position;
  bool position_changed;

  pImpl(void)
    : width(0), height(0), selected_index(NoSelect), decided_index(NoSelect),
      position_changed(true) {
    set_SdlRect(&position, 0, 0, 0, 0);
  }

  void updateComponentSize(void) {

    size_t max_width = 0, max_height = 0;
    int x = 0, y = 0;
    for (std::vector<MenuItem>::iterator it = items.begin();
	 it != items.end(); ++it) {

      int w = x + it->button->getWidth();
      if (w > static_cast<int>(max_width)) {
	max_width = w;
      }

      int h = y + it->button->getHeight();
      if (h > static_cast<int>(max_height)) {
	max_height = h;
      }
      it->position.x = x;
      it->position.y = y;

      x += it->offset.x;
      y += it->offset.y;
    }
    width = max_width;
    height = max_height;
    position.w = max_width;
    position.h = max_height;
  }
};


MenuComponent::MenuComponent(void) : pimpl(new pImpl) {
}


MenuComponent::~MenuComponent(void) {
}


void MenuComponent::addSurfaceList(SurfaceList& surfaces,
				   const SDL_Rect* area, size_t ticks) {
  if (pimpl->items.empty()) {
    return;
  }

  int index = 0;
  int x = 0, y = 0;
  for (std::vector<pImpl::MenuItem>::iterator it = pimpl->items.begin();
       it != pimpl->items.end(); ++it) {
    boost::shared_ptr<ButtonComponent>& p = it->button;

    SDL_Rect position;
    set_SdlRect(&position, pimpl->position.x + x, pimpl->position.y + y,
		p->getWidth(), p->getHeight());
    // !!! ŁAposition_changed  true ɂȂ̂ŁAĕ`悳
    // !!! setPosition ̂́A
    // !!! EsetItemsOffset() ݂̂ł悢͂
    // !!! AMenuComponent::setPosition() ̂ƂɂAʒu͍XV
    if (pimpl->position_changed) {
      p->setPosition(&position);
    }

    x += it->offset.x;
    y += it->offset.y;

    if (index != pimpl->selected_index) {
      // ʏT[tFX
      p->showNormalSurface();

    } else {
      if (index == pimpl->decided_index) {
	// Ăꍇ
	p->showPressedSurface();
      } else {
	// IT[tFX
	p->showFocusedSurface();
      }
    }

    p->addSurfaceList(surfaces, area, ticks);
    ++index;
  }
  pimpl->position_changed = false;
}


void MenuComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position, position->x, position->y,
	      pimpl->position.w, pimpl->position.h);
  pimpl->updateComponentSize();
  pimpl->position_changed = true;
}


void MenuComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position;
}


size_t MenuComponent::getWidth(void) {
  return pimpl->width;
}


size_t MenuComponent::getHeight(void) {
  return pimpl->height;
}


void MenuComponent::applyInput(const InputEvent& event) {

  if (pimpl->decided_index != NoSelect) {
    // ɉԂȂ΁AԂXVȂ
    return;
  }

  // }EXʒuɂ鍀ڂIɂ
  int index = 0;
  int x = 0, y = 0;
  if (event.mouse_moved) {
    for (std::vector<pImpl::MenuItem>::iterator it = pimpl->items.begin();
	 it != pimpl->items.end(); ++it) {
      boost::shared_ptr<ButtonComponent>& p = it->button;

      // !!! button  applyInput KpH
      // !!! ButtonComponent AČ

      SDL_Rect surface_area;
      set_SdlRect(&surface_area, pimpl->position.x + x, pimpl->position.y + y,
		  p->getWidth(), p->getHeight());

      // }EXA\T[tFXɂꍇ̏
      // !!! ۂɂ͕`悳ĂȂꍇ肤邪AƂ肠CɂȂ
      if (((event.mx >= surface_area.x) &&
	   (event.mx <= surface_area.x + surface_area.w)) &&
	  ((event.my >= surface_area.y) &&
	   (event.my <= surface_area.y + surface_area.h))) {
	// Iꂽ
	pimpl->selected_index = index;

	if (event.left_released) {
	  // 肳ꂽ
	  pimpl->decided_index = index;
	}
	break;
      }

      x += it->offset.x;
      y += it->offset.y;
      ++index;
    }
  }

  // L[{[hɂ荀ڂIA肷
  for (std::vector<SDLKey>::const_iterator it = event.key_released.begin();
       it != event.key_released.end(); ++it) {

    int max = pimpl->items.size() - 1;
    if ((pimpl->selected_index > 0) && (*it == SDLK_UP)) {
      // 
      --pimpl->selected_index;

    } else if ((pimpl->selected_index < max) &&  (*it == SDLK_DOWN)) {
      // 
      ++pimpl->selected_index;

    } else if (*it == SDLK_LEFT) {
      // ňԏ
      pimpl->selected_index = 0;

    } else if (*it == SDLK_RIGHT) {
      // Eňԉ
      pimpl->selected_index = max;

    } else if (*it == SDLK_RETURN) {
      // ^[L[Ō
      pimpl->decided_index = pimpl->selected_index;
      break;
    }
  }
}


void MenuComponent::registerLayer(Layer* layer) {
  // Ȃ
}


void MenuComponent::clearItems(void) {
  pimpl->items.clear();
}


void MenuComponent::addItem(boost::shared_ptr<ButtonComponent> item,
			    int x_offset, int y_offset) {

  // {^̒ǉ
  pimpl->items.push_back(pImpl::MenuItem(item, x_offset, y_offset));

  // width, height ̍ČvZ
  pimpl->updateComponentSize();
  pimpl->position_changed = true;
  // !!!
  // !!! Ƃ肠Ao^ꂽR|[lgԂ
  pimpl->width = item->getWidth();
  pimpl->height = item->getHeight();
}


void MenuComponent::setItemsOffset(int x_offset, int y_offset) {

  for (std::vector<pImpl::MenuItem>::iterator it = pimpl->items.begin();
       it != pimpl->items.end(); ++it) {
    it->offset.x = x_offset;
    it->offset.y = y_offset;
  }

  // width, height ̍ČvZ
  pimpl->updateComponentSize();
  pimpl->position_changed = true;
}


void MenuComponent::setSelected(int index) {
  // !!! bN
  pimpl->selected_index = index;
}


void MenuComponent::setDecided(int index) {
  // !!! bN
  pimpl->decided_index = index;
}


int MenuComponent::getSelected(void) {
  return pimpl->selected_index;
}


int MenuComponent::getDecided(void) {
  return pimpl->decided_index;
}


void MenuComponent::releaseDecided(void) {
  for (std::vector<pImpl::MenuItem>::iterator it = pimpl->items.begin();
       it != pimpl->items.end(); ++it) {
    if (it->button->isDecided()) {
      it->button->releaseDecided();
    }
  }
  pimpl->selected_index = pimpl->decided_index;
  pimpl->decided_index = NoSelect;
}
