/*!
  \file
  \brief SDL_mixer ̏NX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "MixerInit.h"
#include "SdlAudioInit.h"
#include "LogManager.h"
#ifdef MSC
#include "SDL_win.h"
#else
#include <SDL_mixer.h>
#endif
#include <stdlib.h>
#include <string>

using namespace beego;


/*!
  \brief MixerInit ̓NX

  \todo Mix ̎gȂ
*/
struct MixerInit::pImpl : private SdlAudioInit {
  enum {
    ChannelNum = 8,
  };
  static bool initialized;
  static void cleanup(void) {
    Mix_AllocateChannels(0);
  }

  pImpl(void) {
    if (! isInitialized()) {
      return;
    }

    if (initialized == false)  {
      if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY,
			MIX_DEFAULT_FORMAT, MIX_DEFAULT_CHANNELS, 1024) < 0) {
	// OL^
	LogManager* log = LogManager::getObject();
	std::string message = "Mixer_Init(): " + std::string(Mix_GetError());
	log->write(LogManager::Error, message.c_str());
	return;
      }
      atexit(Mix_CloseAudio);

      Mix_AllocateChannels(pImpl::ChannelNum);
      atexit(cleanup);
      initialized = true;
    }
  }
};

bool MixerInit::pImpl::initialized = false;


MixerInit::MixerInit(void) : pimpl(new pImpl) {
}


MixerInit::~MixerInit(void) {
}


bool MixerInit::isInitialized(void) {
  return pimpl->initialized;
}
