/*!
  \file
  \brief SDL T[tFX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SdlSurface.h"
#include "SdlUtils.h"
#include "LogManager.h"
#include <string>

using namespace beego;


/*!
  \brief SdlSurface ̓NX
*/
struct SdlSurface::pImpl {
  SDL_Surface* scr;
  SDL_Surface* surface;
  bool is_changed;
  bool is_transparent;
  size_t now_percent;

  pImpl(SDL_Surface* sdlSurface, bool transparent_on)
    : scr(SDL_GetVideoSurface()), surface(sdlSurface), is_changed(false),
      is_transparent(false), now_percent(100) {

    if (scr == NULL) {
      LogManager* log = LogManager::getObject();
      std::string message = "SdlSurface::pImpl(): "
	"Screen surface must be created.";
      log->write(LogManager::Warning, message.c_str());
      return;
    }
    if (transparent_on) {
      transparent();
    }
  }

  ~pImpl(void) {
    if (surface) {
      SDL_FreeSurface(surface);
    }
  }

  void transparent(void) {
    if ((surface == NULL) || (scr == NULL)) {
      return;
    }

    Uint32 trans_color = 0;
    if (surface->format->BitsPerPixel == 8) {
      // sNZtH[}bg 8 bit ̏ꍇ
      Uint8 index = *(Uint8 *)surface->pixels;
      SDL_Color& color = surface->format->palette->colors[index];
      trans_color = SDL_MapRGB(surface->format, color.r, color.g, color.b);
    } else {
      trans_color = *(Uint32*)surface->pixels;
    }

    SDL_SetColorKey(surface,
		    SDL_SRCCOLORKEY | SDL_RLEACCEL, trans_color);
    SDL_Surface* transparent_surface = SDL_DisplayFormat(surface);
    SDL_FreeSurface(surface);
    surface = transparent_surface;

    is_transparent = true;
  }
};


SdlSurface::SdlSurface(SDL_Surface* surface, bool transparent)
  : pimpl(new pImpl(surface, transparent)) {
}


SdlSurface::~SdlSurface(void) {
}


bool SdlSurface::isInvalid(void) {
  return (pimpl->surface == NULL) ? true : false;
}


void SdlSurface::transparent(void) {
  pimpl->transparent();
}


void SdlSurface::draw(std::vector<SDL_Rect>& update_rects,
		      const SDL_Rect* pos, const SDL_Rect* area,
		      size_t ticks) {

  if ((pimpl->scr == NULL) &&
      ((pimpl->scr = SDL_GetVideoSurface()) == NULL)) {
    return;
  }

  SDL_BlitSurface(pimpl->surface, const_cast<SDL_Rect*>(area),
		  pimpl->scr, const_cast<SDL_Rect*>(pos));
  update_rects.push_back(*pos);
}


size_t SdlSurface::getWidth(void) {
  return (pimpl->surface == NULL) ? 0 : pimpl->surface->w;
}


size_t SdlSurface::getHeight(void) {
  return (pimpl->surface == NULL) ? 0 : pimpl->surface->h;
}


void SdlSurface::forceSetChanged(void) {
  pimpl->is_changed = true;
}


bool SdlSurface::isChanged(void) {
  bool ret = pimpl->is_changed;
  pimpl->is_changed = false;
  return ret;
}


bool SdlSurface::isTransparent(void) {
  return pimpl->is_transparent;
}


void SdlSurface::setAlpha(size_t percent) {
  percent = (percent > 100) ? 100 : percent;
  if ((percent != pimpl->now_percent) && pimpl->surface) {

    SDL_SetAlpha(pimpl->surface, SDL_SRCALPHA,
		 percent * SDL_ALPHA_OPAQUE / 100);

    pimpl->now_percent = percent;
    pimpl->is_changed = true;
    pimpl->is_transparent = (percent >= 100) ? false : true;
  }
}
