/*!
  \file
  \brief ͕̕\R|[lg

  \author Satofumi KAMIMURA

  $Id$

  \todo I[gs[g
  \todo ̈悩͂ݏoT[tFX͕`悵Ȃ
  \todo ߎ́AwiF߂ɂ
*/

#include "TextInputComponent.h"
#include "InputEvent.h"
#include "TextSurface.h"
#include "ColorSurface.h"
#include "NullSurface.h"
#include "Component.h"
#include "SdlUtils.h"
#include "PlainTextConverter.h"

using namespace beego;


struct TextInputComponent::pImpl {
  SDL_Rect position;
  size_t width;
  size_t height;
  TtfResource* ttf;
  size_t font_size;
  Uint32 fore_color;
  Uint32 back_color;
  bool is_transparent;
  std::vector<Uint16> inputed_text;
  Surface text_surface;
  Surface back_surface;
  bool is_decided;
  bool position_changed;
  PlainTextConverter plain_converter;
  TextConvertInterface* converter;
  size_t x_offset;
  size_t y_offset;
  bool is_changed;
  DrawSurface text_draw_surface;
  DrawSurface back_draw_surface;

  pImpl(size_t w, size_t h, TtfResource* font, size_t size,
	Uint32 foreColor, Uint32 backColor, bool transparent,
	int xOffset, int yOffset)
    : width(w), height(h), ttf(font), font_size(size),
      fore_color(foreColor), back_color(backColor),
      is_transparent(transparent),
      back_surface(new ColorSurface(backColor, width, height)),
      is_decided(false), position_changed(true), converter(&plain_converter),
      x_offset(xOffset), y_offset(yOffset), is_changed(true) {

    set_SdlRect(&position, 0, y_offset, width, height);
    updateSurface();
  }

  void updateSurface(void) {
    converter->getConvertBuffer(inputed_text);

    if (inputed_text.empty()) {
      Surface null_surface(new NullSurface);
      // !!! {́Aswap() ̓[vOɔzuׂAʓ|Ȃ̂ŁAƂ肠...
      std::swap(text_surface, null_surface);

    } else {
      inputed_text.push_back('\0');
      Surface new_surface(new TextSurface(ttf, &inputed_text[0], font_size,
					  fore_color, back_color,
					  is_transparent));
      inputed_text.pop_back();

      // 쐬T[tFX\̈zA
      if ((new_surface->getWidth() + x_offset) > width) {
	inputed_text.pop_back();
	return;
      }
      std::swap(text_surface, new_surface);
    }

    // ʒuςƂɂāAĕ`悷
    // !!! ł΁Aʂ̘gg݂łȂƂȂ...
    // !!! \p̃T[tFX΁AőΏł邯ǂȂ...
    // !!! \todo ̂
    position_changed = true;
    is_changed = true;
  }
};


TextInputComponent::TextInputComponent(size_t width, size_t height,
				       TtfResource* font, size_t size,
				       Uint32 fore_color, Uint32 back_color,
				       bool transparent,
				       int x_offset, int y_offset)
  : pimpl(new pImpl(width, height, font, size,
		    fore_color, back_color, transparent, x_offset, y_offset)) {
}


TextInputComponent::~TextInputComponent(void) {
}


void TextInputComponent::addSurfaceList(SurfaceList& surfaces,
					const SDL_Rect* area, size_t ticks) {

  // !!! ̎ɂ́ÃT[tFXo^Ă܂̂A肩
  // !!! NullSurface o^邱Ƃɂ
  // T[tFX̔zu

  // !!! {́ÂŃT[tFXׂAH
  // !!! \\ɑ΁Aǂł悢bȁI

  SDL_Rect text_position = pimpl->position;
  text_position.x += pimpl->x_offset;
  text_position.y += pimpl->y_offset;

  updateDrawSurface(pimpl->text_draw_surface, pimpl->text_surface, area,
		    text_position, pimpl->position_changed);
  surfaces.push_back(&pimpl->text_draw_surface);

  // wiT[tFX̔zu
  updateDrawSurface(pimpl->back_draw_surface, pimpl->back_surface, area,
		    pimpl->position, pimpl->position_changed);
  surfaces.push_back(&pimpl->back_draw_surface);

  pimpl->position_changed = false;
}


void TextInputComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position, position->x, position->y,
	      pimpl->position.w, pimpl->position.h);
  pimpl->position_changed = true;
}


void TextInputComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position;
}


size_t TextInputComponent::getWidth(void) {
  return pimpl->position.w;
}


size_t TextInputComponent::getHeight(void) {
  return pimpl->position.h;
}


void TextInputComponent::applyInput(const InputEvent& event) {
  if (pimpl->is_decided) {
    // ͊ḿA͂󂯕tȂ
    return;
  }

  // !!! ͂ϊĂ̕\
  bool text_changed = false;
  for (std::vector<InputEvent::InputKey>::const_iterator
	 it = event.key_pressed.begin(); it != event.key_pressed.end(); ++it) {

    // L[͓ʈƂ
    // !!! {́As̃L[͂K؂ɏׂ
    // !!! ... K؂ĂȂ񂾁H ςÂĂ邵񂶂Ȃ́H

    if (it->sym == SDLK_RETURN) {
      pimpl->is_decided = true;
      pimpl->is_changed = true;
      return;

    } else if (it->sym == SDLK_ESCAPE) {
      text_changed |= pimpl->converter->escapePressed();
      continue;

    } else if (it->sym == SDLK_BACKSPACE) {
      text_changed |= pimpl->converter->deleteBack();
      continue;

    } else if (it->sym == SDLK_DELETE) {
      text_changed |= pimpl->converter->deleteCurrent();
      continue;

    } else if ((it->unicode & 0xff00) || (! isprint(it->unicode))) {
      // \łȂL[͂́AƂĈȂ
      continue;
    }
    // !!! J[\ړ

    text_changed |= pimpl->converter->addChar(it->unicode);
  }
  if (text_changed) {
    pimpl->updateSurface();
  }
}


void TextInputComponent::registerLayer(Layer* layer) {
  // Ȃ
}


bool TextInputComponent::isDecided(void) {
  return pimpl->is_decided;
}


void TextInputComponent::releaseDecided(void) {
  pimpl->is_decided = false;
}


void TextInputComponent::clear(void) {
  //fprintf(stderr, "clear\n");
  pimpl->converter->clear();
  pimpl->updateSurface();

  // ʒuςƂɂāAĕ`悷
  pimpl->position_changed = true;
}


size_t TextInputComponent::getBuffer(std::vector<Uint16>& buffer) {

  buffer = pimpl->inputed_text;
  size_t size = buffer.size();
  buffer.push_back('\0');

  return size;
}


void TextInputComponent::setBuffer(std::vector<Uint16>& data) {

  pimpl->converter->setConvertBuffer(data);
  pimpl->updateSurface();
}


void TextInputComponent::swapTextConverter(TextConvertInterface* converter) {
  pimpl->converter = converter;
}


bool TextInputComponent::empty(void) {
  return pimpl->inputed_text.empty();
}


bool TextInputComponent::isChanged(void) {
  bool ret = pimpl->is_changed;
  pimpl->is_changed = false;
  return ret;
}
