/*!
  \file
  \brief PFT[tFX

  \author Satofumi KAMIMURA

  $Id$

  \todo lύX郁\bhǉ
*/

#include "ColorSurface.h"
#include "LogManager.h"
#include "SdlUtils.h"
#include "GuiColors.h"
#include <string>

using namespace beego;


struct ColorSurface::pImpl {
  SDL_Surface* scr;
  Uint32 surface_color;
  size_t width;
  size_t height;
  bool is_changed;

  pImpl(Uint32 color, size_t w, size_t h)
    : scr(SDL_GetVideoSurface()), width(w), height(h), is_changed(false) {
    if (scr == NULL) {
      LogManager* log = LogManager::getObject();
      std::string message = "SdlSurface::pImpl(): "
	"Screen surface must be created.";
      log->write(LogManager::Warning, message.c_str());
      return;
    }
    surface_color = getSdlColor(scr, color);
  }
};


ColorSurface::ColorSurface(Uint32 color, size_t width, size_t height)
  : pimpl(new pImpl(color, width, height)) {
}


ColorSurface::~ColorSurface(void) {
}

void ColorSurface::draw(std::vector<SDL_Rect>& update_rects,
			const SDL_Rect* pos, const SDL_Rect* area,
			size_t ticks) {

  SDL_FillRect(pimpl->scr, const_cast<SDL_Rect*>(pos), pimpl->surface_color);
  update_rects.push_back(*pos);
}


size_t ColorSurface::getWidth(void) {
  return pimpl->width;
}


size_t ColorSurface::getHeight(void) {
  return pimpl->height;
}


void ColorSurface::forceSetChanged(void) {
  pimpl->is_changed = true;
}


bool ColorSurface::isChanged(void) {
  bool ret = pimpl->is_changed;
  pimpl->is_changed = false;
  return ret;
}


bool ColorSurface::isTransparent(void) {
  return false;
}
