/*!
  \file
  \brief Label R|[lg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "LabelComponent.h"
#include "SurfaceInterface.h"
#include "Component.h"
#include "SdlUtils.h"

using namespace beego;


/*!
  \brief LabelComponent ̓NX
*/
struct LabelComponent::pImpl {
  Surface surface;
  SDL_Rect position;
  bool position_changed;
  DrawSurface draw_surface;

  pImpl(Surface obj) : surface(obj), position_changed(true) {
    set_SdlRect(&position, 0, 0, surface->getWidth(), surface->getHeight());
  }
};


LabelComponent::LabelComponent(Surface surface) : pimpl(new pImpl(surface)) {
}


LabelComponent::~LabelComponent(void) {
}


void LabelComponent::addSurfaceList(SurfaceList& surfaces,
				    const SDL_Rect* area, size_t ticks) {

  updateDrawSurface(pimpl->draw_surface, pimpl->surface, area,
		    pimpl->position, pimpl->position_changed);
  surfaces.push_back(&pimpl->draw_surface);
  pimpl->position_changed = false;
}


void LabelComponent::setPosition(const SDL_Rect* position) {
  set_SdlRect(&pimpl->position, position->x, position->y,
	      pimpl->position.w, pimpl->position.h);
  pimpl->position_changed = true;
}


void LabelComponent::getPosition(SDL_Rect* position) {
  *position = pimpl->position;
}


size_t LabelComponent::getWidth(void) {
  return pimpl->position.w;
}


size_t LabelComponent::getHeight(void) {
  return pimpl->position.h;
}


void LabelComponent::applyInput(const InputEvent& event) {
  // !!!
}


void LabelComponent::registerLayer(Layer* layer) {
  // Ȃ
}
