/*!
  \file
  \brief C[Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo LogManager ܂肪 SdlSurface ƓȂ΂
  \todo remove ƂɁAĕ`悷邱Ƃۏ؂
*/

#include "LayerManager.h"
#include "Layer.h"
#include "SurfaceInterface.h"
#include "ComponentInterface.h"
#include "GuiColors.h"
#include "EvaluateArea.h"
#include "SdlUtils.h"
#include "LogManager.h"
#include <string>

using namespace beego;


struct LayerManager::pImpl {
  typedef std::vector<Layer*> LayerList;
  SurfaceList& surface_list;
  LayerList layer_list;
  SDL_Surface* scr;
  Uint32 back_color;
  size_t width;
  size_t height;
  std::vector<SDL_Rect> back_rects;

  pImpl(SurfaceList& surfaces)
    : surface_list(surfaces), scr(SDL_GetVideoSurface()), width(0), height(0) {
    if (scr == NULL) {
      LogManager* log = LogManager::getObject();
      std::string message =
	"LayerManager::pImpl(): Screen surface must be created.";
      log->write(LogManager::Warning, message.c_str());
      return;
    }
    width = scr->w;
    height = scr->h;
    back_color = getSdlColor(scr, Black);
  }
};


LayerManager::LayerManager(SurfaceList& surface_list)
  : pimpl(new pImpl(surface_list)) {
}


LayerManager::~LayerManager(void) {
}


void LayerManager::applyInput(ComponentList& components,
			      const InputEvent& event) {

  for (ComponentList::iterator it = components.begin();
       it != components.end(); ++it) {
    (*it)->applyInput(event);
  }
}


void LayerManager::redraw(std::vector<SDL_Rect>& update_rects,
			  SurfaceList& surfaces, size_t ticks) {

  if (! pimpl->scr) {
    return;
  }

  // wiFł̓hԂ
  for (std::vector<SDL_Rect>::iterator it = pimpl->back_rects.begin();
       it != pimpl->back_rects.end(); ++it) {
    SDL_FillRect(pimpl->scr, &*it, pimpl->back_color);
    update_rects.push_back(*it);
  }
  pimpl->back_rects.clear();

  for (SurfaceList::reverse_iterator rit = surfaces.rbegin();
       rit != surfaces.rend(); ++rit) {
    bool is_changed = (*rit)->is_changed | (*rit)->position_changed;

    if (is_changed) {
      (*rit)->surface->draw(update_rects, &(*rit)->position,
			    &(*rit)->area, ticks);

      // !!!  createSurfaceList() ]ɍ폜̂h
      (*rit)->is_changed = false;
      continue;
    }
  }
}


void LayerManager::push_front(Layer* layer) {
  pimpl->layer_list.insert(pimpl->layer_list.begin(), layer);
  layer->registerManager(this);

  // !!! ̂ƂɁASurfaceList ̍XVs
}


void LayerManager::push_back(Layer* layer) {

  pimpl->layer_list.push_back(layer);
  layer->registerManager(this);

  // !!! ̂ƂɁASurfaceList ̍XVs
}


void LayerManager::insert(const Layer* dst, Layer* layer) {

  pImpl::LayerList::iterator it = find(pimpl->layer_list.begin(),
				       pimpl->layer_list.end(), dst);
  pimpl->layer_list.insert(it, layer);
  layer->registerManager(this);

  // !!! ̂ƂɁASurfaceList ̍XVs
}


void LayerManager::remove(Layer* layer) {

  pImpl::LayerList::iterator it = find(pimpl->layer_list.begin(),
				       pimpl->layer_list.end(), layer);
  if (it != pimpl->layer_list.end()) {
    pimpl->layer_list.erase(it);
  }
}


void LayerManager::createComponentList(ComponentList& components) {

  components.clear();

  for (pImpl::LayerList::iterator it = pimpl->layer_list.begin();
       it != pimpl->layer_list.end(); ++it) {
    (*it)->addComponentList(components);
  }
}


void LayerManager::createSurfaceList(SurfaceList& surfaces,
				     const ComponentList& components,
				     size_t ticks) {

  //fprintf(stderr, "changed evaluate\n");
#if 1
  // ύXꂽT[tFX́AŎ菜čĕ`
  SurfaceList changed_surfaces;
  for (SurfaceList::iterator it = surfaces.begin();
       it != surfaces.end(); ++it) {
    if ((*it)->surface->isChanged()) {
      //fprintf(stderr, "is_changed !\n");
      // redraw() ŕ`悳悤ɁAtOZbgĂ
      (*it)->surface->forceSetChanged();
      changed_surfaces.push_back(*it);
    }
  }
  removeSurface(changed_surfaces);
#endif

  // 폜̈̍XV

  // !!! ɁÂ͐p̊֐ɂĂ܂܂傤

  // !!! Ƃ肠폜͈̔͂ňx`悵Ă܂
  // !!! {́Aĕ`͍Ōɂ܂Ƃ߂čs΂悢͂
  std::vector<SDL_Rect> update_rects;
  for (SurfaceList::iterator it = surfaces.begin();
       it != surfaces.end(); ++it) {
    std::vector<SDL_Rect>& redraw_rects = (*it)->redraw_rects;
    for (std::vector<SDL_Rect>::iterator draw_it = redraw_rects.begin();
	 draw_it != redraw_rects.end(); ++draw_it) {
      SDL_Rect draw_area;
      set_SdlRect(&draw_area, draw_it->x - (*it)->position.x,
		  draw_it->y - (*it)->position.y, draw_it->w, draw_it->h);
      (*it)->surface->draw(update_rects, &*draw_it, &draw_area, 0);
    }
    redraw_rects.clear();
  }

  // !!! `AƂ肠Aupdate_rects Ă܂
  // !!! 蒼ׂ
  // !!! `揈AC[̒łĂ̂
  // !!! ꏊAɈڂA̕`揈ɎĂ
  if (pimpl->scr) {
    SDL_UpdateRects(pimpl->scr, update_rects.size(), &update_rects[0]);
  }
  // !!! ܂łAsurfaces NAǑォÂB֐

  surfaces.clear();

  SDL_Rect area;
  set_SdlRect(&area, 0, 0, pimpl->width -1, pimpl->height -1);

  for (ComponentList::const_iterator it = components.begin();
       it != components.end(); ++it) {
    (*it)->addSurfaceList(surfaces, &area, ticks);
  }

#if 0
  for (SurfaceList::iterator it = surfaces.begin();
       it != surfaces.end(); ++it) {
    fprintf(stderr, "%p, ", &it->surface);
  }
  fprintf(stderr, "\n");
#endif
}


void LayerManager::removeSurface(SurfaceList& remove_list) {

  // O폜T[tFX܂ŁAĕ`̈]

  // !!! Ƃ肠ASʂɑ΂ĕ]s
  // !!! ʕ́A{͂Ǝ擾ׂ
  SDL_Rect all_area;
  set_SdlRect(&all_area, 0, 0, 640, 480);
  std::vector<SDL_Rect> redraw_areas;
  redraw_areas.push_back(all_area);

  // ̈
  for (std::vector<SDL_Rect>::iterator redraw_it = redraw_areas.begin();
       redraw_it != redraw_areas.end(); ++redraw_it) {

    // 폜T[tFX
    // !!! ŁA폜T[tFXԂŁAdȂ̈]Ă悳
    for (SurfaceList::iterator remove_it = remove_list.begin();
	 remove_it != remove_list.end(); ++remove_it) {

      std::vector<SDL_Rect> remove_area;
      add_SdlRect(remove_area,
		  (*remove_it)->position.x, (*remove_it)->position.y,
		  (*remove_it)->area.w, (*remove_it)->area.h);
      //fprintf(stderr, "remove_area: %d, %d, %d, %d\n", (*remove_it)->position.x, (*remove_it)->position.y, (*remove_it)->area.w, (*remove_it)->area.h);

      std::vector<SDL_Rect> common_area; // gȂ
      std::vector<SDL_Rect> unique_area; // 폜T[tFX̌Ă镔
      bool front_surface = true;

      // ǗĂT[tFX
      for (SurfaceList::iterator surface_it = pimpl->surface_list.begin();
	   surface_it != pimpl->surface_list.end(); ++surface_it) {

	SDL_Rect surface_area;
	set_SdlRect(&surface_area,
		    (*surface_it)->position.x, (*surface_it)->position.y,
		    (*surface_it)->area.w, (*surface_it)->area.h);

	if (front_surface) {
	  // OʃT[tFXƂ̕]
	  // Ă̈ remove_area ɓo^Ă

	  if (*surface_it == *remove_it) {

	    // T[tFX܂ŕ]A͔wʂ̕]s
	    front_surface = false;

	    // T[tFX͍폜邽߁Ao^Ăĕ`͎̈ɓn
	    // !!! ̏AӖ̂ȁH
	    for (std::vector<SDL_Rect>::iterator it =
		   (*surface_it)->redraw_rects.begin();
		 it != (*surface_it)->redraw_rects.end(); ++it) {
	      remove_area.push_back(*it);
	    }

	    // T[tFX̓o^폜
	    surface_it = pimpl->surface_list.erase(surface_it);
	    --surface_it;

	    continue;
	  }

	  // 폜T[tFX̌Ă镔 remove_area ɓo^
	  unique_area.clear();
	  common_area.clear();
	  for (std::vector<SDL_Rect>::iterator unique_it = remove_area.begin();
	       unique_it != remove_area.end(); ++unique_it) {
	    evaluateArea(common_area, unique_area, *unique_it, surface_area);

	    // !!! ȍ~A֐ĂB
	    // ߃T[tFX̂Ƃ́Acommon ȍ~̃T[tFXɓn
	    if ((*surface_it)->is_transparent) {
	      unique_area.insert(unique_area.end(),
				 common_area.begin(), common_area.end());
	    }
	  }
	  remove_area = unique_area;

	} else {
	  // wʃT[tFXƂ̕]
	  // remove_area ̗̈AwʂɂT[tFXɍĕ`悳

	  common_area.clear();
	  unique_area.clear();
	  for (std::vector<SDL_Rect>::iterator it = remove_area.begin();
	       it != remove_area.end(); ++it) {

	    // dȂ蔻sAcommon ̃T[tFXAunique ̃T[tFX
	    evaluateArea(common_area,
			 unique_area, *it, surface_area);
	    std::vector<SDL_Rect>::iterator last_it =
	      (*surface_it)->redraw_rects.end();
	    (*surface_it)->redraw_rects.insert(last_it, common_area.begin(),
					       common_area.end());

	    // ߃T[tFX̂Ƃ́Acommon ȍ~̃T[tFXɓn
	    if ((*surface_it)->is_transparent) {
	      unique_area.insert(unique_area.end(),
				 common_area.begin(), common_area.end());
	    }
	  }
	  remove_area = unique_area;
	}
      }
      // remove_area ŔwʂƂāAĕ`̈ɓo^
      for (std::vector<SDL_Rect>::iterator it = remove_area.begin();
	   it != remove_area.end(); ++it) {
	pimpl->back_rects.push_back(*it);
      }
    }
  }
}
