/*!
  \file
  \brief lbg[Ñj[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "NetworkMenu.h"
#include "NetworkMenu_uni.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "TextSurface.h"
#include "LabelComponent.h"
#include "MenuComponent.h"
#include "ButtonComponent.h"
#include "LockGuard.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct NetworkMenu::pImpl {
  CommonResources* common;
  SDL_mutex* mutex;
  TtfResource* font;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;

  pImpl(void)
    : common(CommonResources::getObject()), mutex(common->gui->getMutex()),
      title_surface(new TextSurface(common->font, NetworkMenu_title, TitleSize,
				    Fore, Back, true)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent) {

    // ^Cg̈ʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2),
		middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[̐Aʒuݒ
    // j[̍ڂ쐬
    const Uint16 *titles[] = {
      NetworkMenu_player, NetworkMenu_data, NetworkMenu_back,
    };
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      ButtonComponent::createSimpleButton(new_button, common->font,
					  titles[i], MenuSize, Fore, Back,
					  MenuSize, Selected, Back, true);
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setSelected(0);

    set_SdlRect(&position, centerPosition(menu, 640/2),	480/4 + MenuOffset);
    menu->setPosition(&position);
  }

  void placeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
  }

  void removeComponents(void) {
    LockGuard guard(mutex);
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
  }
};


NetworkMenu::NetworkMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


NetworkMenu::~NetworkMenu(void) {
  pimpl->removeComponents();
}


void NetworkMenu::run(void) {

  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    if (selected >= 0) {
      pimpl->removeComponents();

      if (selected == 0) {
	// ΐl
	// !!!

      } else if (selected == 1) {
	// ߋf[^Ƃ̑ΐ
	// !!!

      } else if (selected == 2) {
	// ߂
	quit |= true;
      }

      // j[đI\ɂ
      pimpl->placeComponents();
      LockGuard guard(pimpl->mutex);
      pimpl->menu->releaseDecided();
    }

    input.update_all();
    quit |= input.isReleased(SDLK_ESCAPE);
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    delay(1);
  }
}
