/*!
  \file
  \brief SDL y̏

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SdlAudioInit.h"
#include "SdlInit.h"
#include "LogManager.h"
#ifdef MSC
#include "SDL_win.h"
#else
#include <SDL.h>
#endif
#include <stdlib.h>
#include <string>

using namespace beego;


struct SdlAudioInit::pImpl : private SdlInit {
  static bool initialized;
};

bool SdlAudioInit::pImpl::initialized = false;


SdlAudioInit::SdlAudioInit(void) : pimpl(new pImpl) {
  if (pimpl->initialized == false) {
    if (SDL_InitSubSystem(SDL_INIT_AUDIO) < 0) {
      // OL^
      LogManager* log = LogManager::getObject();
      std::string message = "SDL_Init(): " + std::string(SDL_GetError());
      log->write(LogManager::Error, message.c_str());
    }
    atexit(SDL_Quit);
    pimpl->initialized = true;
  }
}


SdlAudioInit::~SdlAudioInit(void) {
}


bool SdlAudioInit::isInitialized(void) {
  return pimpl->initialized;
}
