#ifndef SDL_VIDEO_H
#define SDL_VIDEO_H

/*!
  \file
  \brief SDL ̉ʑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <SDL.h>
#include <memory>


namespace beego {
  namespace SDL {
    /*!
      \brief SDL ̉ʑNX
    */
    class SdlVideo {
      SdlVideo(const SdlVideo& rhs);
      SdlVideo& operator = (const SdlVideo& rhs);

      struct pImpl;
      const std::auto_ptr<pImpl> pimpl;

    public:
      SdlVideo(void);
      ~SdlVideo(void);
      const char* what(void);

      void setFullscreenMode(bool on = true);
      SDL_Surface* show(Uint32 mode = 0);
      void hide(void);

      void setCaption(const char* caption);
      void setWindowBpp(size_t bpp);
      void setWindowSize(size_t width, size_t height);
      size_t getWidth(void);
      size_t getHeight(void);
    };
  };
};

#endif /* !SDL_VIDEO_H */
