#ifndef SOUND_EFFECT_MANAGER_H
#define SOUND_EFFECT_MANAGER_H

/*!
  \file
  \brief ʉ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


namespace beego {
  /*!
    \brief ʉ̊ǗNX
  */
  class SoundEffectManager {
    SoundEffectManager(const SoundEffectManager& rhs);
    SoundEffectManager& operator = (const SoundEffectManager& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    SoundEffectManager(void);
    ~SoundEffectManager(void);

    bool registerEffect(int effect_id, const char* file_path);
    void unregisterEffect(int effect_id);

    // ʂ̊ݒ
    void updateVolume(size_t percent);

    // ĐJn, Ǘp̍Đ ID Ԃ, ʂw\, tF[hCw
    int play(int effect_id, size_t fade_in_msec, int volume_percent);

    // ID wɂ~AtF[hAEgwAI҂̂
    void stop(int effect_id, size_t fade_out_msec);

    // !!! ܂̃\bhÂ

    // !!! Ƀ{[ݒ肷郁\bhƂH
  };
};

#endif /* !SOUND_EFFECT_MANAGER_H */
