#ifndef TYPING_RECORDER_H
#define TYPING_RECORDER_H

/*!
  \file
  \brief ^CsŐL^

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <vector>


/*!
  \brief ^CsŐL^NX
*/
class TypingRecorder {
  TypingRecorder(const TypingRecorder& rhs);
  TypingRecorder& operator = (const TypingRecorder& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  /*!
    \brief 
  */
  enum {
    Clear = 0x1,		//!< NA
    BackSpace = 0x2,		//!< obNXy[X
    Return = 0x3,		//!< s
    Complete = 0x4,		//!< ͊
  };

  /*!
    \brief L[͏
  */
  typedef struct {
    size_t ticks;		//!< ̓^C~O
    char ch;			//!< ̓L[
  } KeyTiming;

  /*!
    \brief ^CsO
  */
  typedef enum {
    ShimonokuTyping,
    KimarijiTyping,
  } TypingMode;

  /*!
    \brief ȁ
  */
  typedef struct {
    size_t no;			//!< a̔ԍ
    std::vector<KeyTiming> keys; //!< ̓L[
  } WakaTyping;

  /*!
    \brief Q[
  */
  typedef struct {
    int rand_seed;		//!< _V[h
    TypingMode mode;		//!< ^CsO[h
    std::vector<WakaTyping> waka; //!< ȁ
  } GameSettings;

  TypingRecorder(void);
  ~TypingRecorder(void);

  /*!
    \brief Q[̋L^Jn

    \param rand_seed [i] _V[h
    \param mode [i] ^CsO[h
  */
  void recordGame(int rand_seed, TypingMode mode);

  /*!
    \brief ȁ̋L^Jn

    \param no [i] a̔ԍ
  */
  void recordWaka(size_t no);

  /*!
    \brief ^CsŐL^

    \param ch [i] ̓L[
    \param ticks [i] ̓^CsO
  */
  void recordTyping(char ch, size_t ticks);

  /*!
    \brief o^e̕]
  */
  void evaluate(void);

  /*!
    \brief a̐̎擾
  */
  size_t getWakaNum(void);

  /*!
    \brief ͒x̎擾
  */
  double getStartDelay(void);

  /*!
    \brief ^CsOXs[h̎擾
  */
  double getTypingSpeed(void);

  /*!
    \brief ^Cv~X̎擾
  */
  size_t getMissTypes(void);

  void to_s(void);

  // !!! Ƃ肠A\
  void print(void);
};

#endif /* !TYPING_RECORDER_H */
