#ifndef __IDT_H__
#define __IDT_H__

#include "types.h"
#include "descripter.h"

struct IdtEntry 
{
    uint16 offset_low;
    uint16 selector;
    uint16 copy :8;
    uint16 type :8;
    uint16 offset_hi;
} __attribute__ ((packed));

class Idt 
{
public:
    static const int NUM = 256;

    void init(void);
    void set(int index, uint32 offset, uint16 selector, uint8 copy, uint8 type);
    void load(void) const;

private:
    DescripterTable table      __attribute__((aligned(8)));
    IdtEntry        entry[NUM] __attribute__((aligned(8)));
};

#endif /* __IDT_H__ */
