#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__

#include "kernel.h"
#include "intmgr.h"
#include "shell.h"
#include "event.h"

class KeyPressEvent : public Event
{
public:
    KeyPressEvent(uint16 code) : KeyCode(code) {
        Id = KEY_PRESS_EVENT;
    }
    uint16 getKeyCode(void) const {return KeyCode;}

private: 
    uint16 KeyCode;
};

class KeyMapper
{
public:
    static const uint8 NULL_CODE        = 0x00;
    static const uint8 EXTEND0_KEY_CODE = 0xE0;
    static const uint8 EXTEND1_KEY_CODE = 0xE1;
    static const uint8 BREAK_KEY_CODE   = 0x80;

    KeyMapper(void) : KeyMap(KeyMap_104JP), Mode(NULL_CODE) {}
    Event* translate(uint8 code);

private:
    static const char KeyMap_104JP[];
    const char* KeyMap;

    uint8 Mode;
};

class KeyboardInterruptHandler : public InterruptHandler
{
private:
    KeyMapper Mapper;

public:
    void operator()(uint32 intNum) {
        uint8 data = IoPortLib::in8(IoPortLib::KBD_DATA);
        IntMgr::getInstance()->setEoi(IntMgr::KEYBOARD_IRQ);

        Event* evt = Mapper.translate(data);
        if ((evt != 0) && (ShellTaskPtr != 0))
            ShellTaskPtr->sendEvent(*evt);
    }
};

#endif /*__KEYBOARD_H__ */
