#include "shell.h"
#include "screen.h"
#include "keyboard.h"

Task* ShellTaskPtr = 0;

void ShellTask::run(void) {
    /* Shell init */
    Stdout = &Console;
    ShellTaskPtr = this;

    /* Main loop */
    KeyMapper mapper;
    while (true) {
        Event* evt = waitForEvent();
        if (evt->getId() == Event::KEY_PRESS_EVENT) {
            KeyPressEvent* key_press = (KeyPressEvent*)evt;
            Stdout->putChar(uint8(key_press->getKeyCode() & 0x00FF));
            delete key_press;
        }
    }
}

