/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arefgard.container.IllegalReferenceException;

public class Reference {
    private String nameSpace = null;
    private String target = null;

    public Reference() {
    }

    public Reference(String path) throws IllegalReferenceException {
        try {
            if (path == null || path.equals("")) {
                throw new IllegalReferenceException("\u30d1\u30b9\u304c\u3042\u308a\u307e\u305b\u3093");
            }
            Pattern pattern = Pattern.compile("^[0-9a-zA-Z]+.[0-9a-zA-Z]+$|^[0-9a-zA-Z]+$");
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) {
                throw new IllegalReferenceException("\u4e0d\u6b63\u306a\u30d1\u30b9\u3067\u3059:" + path);
            }
            StringTokenizer tokenizer = new StringTokenizer(path, ".");
            if (tokenizer.countTokens() == 1) {
                this.nameSpace = tokenizer.nextToken();
            }
            if (tokenizer.countTokens() == 2) {
                this.nameSpace = tokenizer.nextToken();
                this.target = tokenizer.nextToken();
            }
        }
        catch (Exception e) {
            throw new IllegalReferenceException("\u5b9f\u884c\u6642\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    public String getReferencePath() throws IllegalReferenceException {
        if (this.nameSpace == null || this.nameSpace.equals("")) {
            throw new IllegalReferenceException("\u30d1\u30b9\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (this.target == null || this.target.equals("")) {
            return this.nameSpace;
        }
        return String.valueOf(this.nameSpace) + "." + this.target;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String service) {
        this.nameSpace = service;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String bean) {
        this.target = bean;
    }

    public String toString() {
        if (this.target != null) {
            return String.valueOf(this.nameSpace) + "." + this.target;
        }
        return this.nameSpace;
    }
}

