/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import junit.framework.TestCase;
import org.arefgard.container.IllegalReferenceException;
import org.arefgard.container.Reference;

public class ReferenceTest
extends TestCase {
    public void testReference1() {
        try {
            Reference ref = new Reference("service.bean");
            ReferenceTest.assertEquals((String)"service", (String)ref.getNameSpace());
            ReferenceTest.assertEquals((String)"bean", (String)ref.getTarget());
            ReferenceTest.assertEquals((String)"service.bean", (String)ref.getReferencePath());
        }
        catch (IllegalReferenceException e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference2() {
        try {
            Reference ref = new Reference("service");
            ReferenceTest.assertEquals((String)"service", (String)ref.getNameSpace());
            ReferenceTest.assertEquals(null, (String)ref.getTarget());
            ReferenceTest.assertEquals((String)"service", (String)ref.getReferencePath());
        }
        catch (IllegalReferenceException e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference3() {
        try {
            new Reference("service.");
            ReferenceTest.fail((String)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        catch (IllegalReferenceException e) {
            ReferenceTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference4() {
        try {
            new Reference(".bean");
            ReferenceTest.fail((String)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        catch (IllegalReferenceException e) {
            ReferenceTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference5() {
        try {
            new Reference("");
            ReferenceTest.fail((String)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        catch (IllegalReferenceException e) {
            ReferenceTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference6() {
        try {
            new Reference(null);
            ReferenceTest.fail((String)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        catch (IllegalReferenceException e) {
            ReferenceTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference7() {
        try {
            Reference ref = new Reference();
            ref.setNameSpace("service");
            ref.setTarget("bean");
            ReferenceTest.assertEquals((String)"service", (String)ref.getNameSpace());
            ReferenceTest.assertEquals((String)"bean", (String)ref.getTarget());
            ReferenceTest.assertEquals((String)"service.bean", (String)ref.getReferencePath());
        }
        catch (IllegalReferenceException e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference8() {
        try {
            Reference ref = new Reference();
            ref.setNameSpace("service");
            ReferenceTest.assertEquals((String)"service", (String)ref.getNameSpace());
            ReferenceTest.assertEquals(null, (String)ref.getTarget());
            ReferenceTest.assertEquals((String)"service", (String)ref.getReferencePath());
        }
        catch (IllegalReferenceException e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference9() {
        try {
            Reference ref = new Reference();
            ref.setTarget("bean");
            ReferenceTest.assertEquals(null, (String)ref.getNameSpace());
            ReferenceTest.assertEquals((String)"bean", (String)ref.getTarget());
            ref.getReferencePath();
            ReferenceTest.fail((String)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        catch (IllegalReferenceException e) {
            ReferenceTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }

    public void testReference10() {
        try {
            Reference ref = new Reference();
            ref.getReferencePath();
            ReferenceTest.fail((String)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        catch (IllegalReferenceException e) {
            ReferenceTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReferenceTest.fail((String)("\u60f3\u5b9a\u5916\u306e\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + e));
        }
    }
}

