/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.HashMap;
import org.arefgard.business.domain.model.Customer;
import org.arefgard.business.domain.model.Employee;
import org.arefgard.container.BusinessService;
import org.arefgard.container.ContainerFactory;
import org.arefgard.container.IceryaContainer;
import org.arefgard.container.Reference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingletonIceryaContainerTest {
    IceryaContainer container = null;

    @Before
    public void setUp() throws Exception {
        try {
            ContainerFactory.initialize("files/test01/components.xml");
            this.container = ContainerFactory.newContainer();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }

    @Test
    public void createObjectFromString() {
        try {
            Employee obj = (Employee)this.container.create("global.employee");
            Assert.assertNotNull((Object)obj);
            Assert.assertEquals(null, (Object)obj.getUserName());
            Assert.assertEquals(null, (Object)obj.getPassword());
            Assert.assertEquals(null, (Object)obj.getFirstName());
            Assert.assertEquals(null, (Object)obj.getLastName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }

    @Test
    public void createObjectFromClassType() {
        try {
            Employee obj = (Employee)this.container.create(Employee.class);
            Assert.assertNotNull((Object)obj);
            Assert.assertEquals(null, (Object)obj.getUserName());
            Assert.assertEquals(null, (Object)obj.getPassword());
            Assert.assertEquals(null, (Object)obj.getFirstName());
            Assert.assertEquals(null, (Object)obj.getLastName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }

    @Test
    public void createObjectFromReference() {
        try {
            Employee obj = (Employee)this.container.create(new Reference("global.employee"));
            Assert.assertNotNull((Object)obj);
            Assert.assertEquals(null, (Object)obj.getUserName());
            Assert.assertEquals(null, (Object)obj.getPassword());
            Assert.assertEquals(null, (Object)obj.getFirstName());
            Assert.assertEquals(null, (Object)obj.getLastName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }

    @Test
    public void createObjectFromStringWithProperty() {
        try {
            HashMap<String, Object> property = new HashMap<String, Object>();
            property.put("userName", "00001");
            property.put("password", "p@ssw0rd");
            Employee obj = (Employee)this.container.create("global.employee", property);
            Assert.assertNotNull((Object)obj);
            Assert.assertEquals((Object)"00001", (Object)obj.getUserName());
            Assert.assertEquals((Object)"p@ssw0rd", (Object)obj.getPassword());
            Assert.assertEquals(null, (Object)obj.getFirstName());
            Assert.assertEquals(null, (Object)obj.getLastName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }

    @Test
    public void createObjectFromReferenceWithProperty() {
        try {
            HashMap<String, Object> property = new HashMap<String, Object>();
            property.put("userName", "00001");
            property.put("password", "p@ssw0rd");
            Employee obj = (Employee)this.container.create(new Reference("global.employee"), property);
            Assert.assertNotNull((Object)obj);
            Assert.assertEquals((Object)"00001", (Object)obj.getUserName());
            Assert.assertEquals((Object)"p@ssw0rd", (Object)obj.getPassword());
            Assert.assertEquals(null, (Object)obj.getFirstName());
            Assert.assertEquals(null, (Object)obj.getLastName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }

    @Test
    public void createServiceFromString() {
        try {
            BusinessService service = this.container.createService("account.signIn");
            Assert.assertNotNull((Object)service);
            service.addInput("customerId", "00001");
            service.addInput("password", "p@ssw0rd");
            service.execute();
            Customer result = (Customer)service.getOutput("return");
            Assert.assertEquals((Object)"00001", (Object)result.getUserName());
            Assert.assertEquals((Object)"p@ssw0rd", (Object)result.getPassword());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("\u4f8b\u5916\u767a\u751f" + e));
        }
    }
}

