/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.aop;

import java.util.HashMap;
import java.util.Map;
import org.arefgard.container.aop.ConstructorStructure;
import org.arefgard.container.aop.FieldStructure;
import org.arefgard.container.aop.MethodStructure;

public class ClassStructure {
    private String packageName;
    private String className;
    private Map<String, FieldStructure> fields = new HashMap<String, FieldStructure>();
    private Map<String, MethodStructure> methods = new HashMap<String, MethodStructure>();
    private Map<String, ConstructorStructure> constructors = new HashMap<String, ConstructorStructure>();

    public ClassStructure(String className) {
        this.className = className;
    }

    public ClassStructure(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    public static ClassStructure parse(Object object) {
        Class<?> cls = object.getClass();
        return ClassStructure.parse(cls);
    }

    public static ClassStructure parse(Class cls) {
        String className = cls.getSimpleName();
        String packageName = cls.getPackage().getName();
        ClassStructure structure = new ClassStructure(packageName, className);
        ConstructorStructure[] constructors = ConstructorStructure.parse(cls);
        int length = constructors.length;
        int i = 0;
        while (i < length) {
            structure.addConstructor(constructors[i]);
            ++i;
        }
        MethodStructure[] methods = MethodStructure.parse(cls);
        length = methods.length;
        int i2 = 0;
        while (i2 < length) {
            structure.addMethod(methods[i2]);
            ++i2;
        }
        FieldStructure[] fields = FieldStructure.parse(cls);
        length = fields.length;
        int i3 = 0;
        while (i3 < length) {
            structure.addField(fields[i3]);
            ++i3;
        }
        return structure;
    }

    public void addConstructor(ConstructorStructure constructor) {
        StringBuffer sb = new StringBuffer();
        int size = constructor.length();
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append("_");
            }
            sb.append(constructor.getParameterType(i));
            ++i;
        }
        this.constructors.put(sb.toString(), constructor);
    }

    public ConstructorStructure getConstructor(Object[] object) {
        StringBuffer sb = new StringBuffer();
        int size = object.length;
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append("_");
            }
            sb.append(ClassStructure.getType(object[i].getClass().getName()));
            ++i;
        }
        return this.constructors.get(sb.toString());
    }

    public void addMethod(MethodStructure method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getMethodName());
        int size = method.length();
        int i = 0;
        while (i < size) {
            sb.append("_");
            sb.append(method.getParameterType(i));
            ++i;
        }
        this.methods.put(sb.toString(), method);
    }

    public MethodStructure getMethod(String name) {
        return this.methods.get(name);
    }

    public void addField(FieldStructure fs) {
        this.fields.put(fs.getFieldName(), fs);
    }

    public FieldStructure getField(String name) {
        return this.fields.get(name);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public MethodStructure getMethod(String methodName, Object[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(methodName);
        int length = params.length;
        int i = 0;
        while (i < length) {
            sb.append("_");
            sb.append(ClassStructure.getType(params[i].getClass().getName()));
            ++i;
        }
        return this.methods.get(sb.toString());
    }

    public MethodStructure getSetter(String property, Class cls) {
        StringBuffer sb = new StringBuffer();
        sb.append("set");
        sb.append(property.substring(0, 1).toUpperCase());
        sb.append(property.substring(1));
        sb.append("_");
        sb.append(cls.getName());
        return this.methods.get(sb.toString());
    }

    private static String getType(String typeName) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        if (typeName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (typeName.equals("byte")) {
            return "java.lang.Byte";
        }
        if (typeName.equals("char")) {
            return "java.lang.Character";
        }
        if (typeName.equals("double")) {
            return "java.lang.Double";
        }
        if (typeName.equals("float")) {
            return "java.lang.Float";
        }
        if (typeName.equals("int")) {
            return "java.lang.Integer";
        }
        if (typeName.equals("long")) {
            return "java.lang.Long";
        }
        if (typeName.equals("short")) {
            return "java.lang.Short";
        }
        if (typeName.equals("void")) {
            return "java.lang.Void";
        }
        return typeName;
    }
}

