package org.arefgard.container;

/**
 * <code>ContainerException</code> is the superclass of those exceptions
 * that can be thrown to indicate that a container is not in an appropriate
 * state.
 * 
 * @since IceryaContainer 1.0
 * @author T.A.K.A.Dark
 */
public class ContainerException extends Exception {
	
	/**
	 * Consturcts a new exception with <code>null</null> as its detail message.
	 * The cause is not initialized, and may subsequently be initialized by a
	 * call to <code>Throwable.initCause(java.lang.Throwable)</code>.
	 */
	public ContainerException() {
		super();
	}
	
	/**
	 * Constructs a new exception with the specified detail message. The cause
	 * is not initialized, and may subsequently bu initialized by a call to 
	 * <code>Throwable.initCause(java.lang.Throwable)</code>.
	 * 
	 * @param message the detail message.
	 */
	public ContainerException(String message) {
		super(message);
	}
	
	/**
	 * Constructs a new exception with the specified detail message and cause.
	 * 
	 * @param message the detail message
	 * @param cause the cause.
	 */
	public ContainerException(String message, Throwable cause) {
		super(message, cause);
	}
}
