package org.arefgard.container;

import java.util.List;
import java.util.Map;

import org.arefgard.container.aop.ClassGenerator;

/**
 * サービス定義を保持する。
 * 
 * @author T.A.K.A.Dark
 *
 */
public class ServiceDef {

	private String name;
	private Map<String, InputDef> input;
	private List<ComponentDef> component;
	private FlowDef flow;
	private List<OutputDef> output;
	private String className;
	
	
	/**
	 * サービス名を指定するコンストラクタ。
	 * 
	 * @param name サービス名
	 * @throws ContainerException
	 */
	public ServiceDef(String name) throws ContainerException {
		this.name = name;
		input = new java.util.HashMap<String, InputDef>();
		component = new java.util.ArrayList<ComponentDef>();
		output = new java.util.ArrayList<OutputDef>();
	}
	
	/**
	 * サービス名を取得する。
	 * 
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * サービス名を設定する。
	 * 
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * クラス名を取得する。
	 * 
	 * @return
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * クラス名を設定する。
	 * 
	 * @param className
	 */
	public void setClassName(String className) {
		this.className = className;
	}
	
	public void addInputDef(InputDef inputDef) {
		input.put(inputDef.getName(), inputDef);
	}
	
	public InputDef getInputDef(String name) {
		return input.get(name);
	}
	
	public void addOutputDef(OutputDef outputDef) {
		output.add(outputDef);
	}
	
	public int getOutputLength() {
		return this.output.size();
	}
	
	public OutputDef getOutputDef(int i) {
		return this.output.get(i);
	}
	
	public void setFlowDef(FlowDef flowDef) {
		this.flow = flowDef;
	}
	
	public FlowDef getFlowDef() {
		return this.flow;
	}
	
	public void addComponentDef(ComponentDef componentDef) {
		component.add(componentDef);
	}
	
	public int getComponentDefLength() {
		return component.size();
	}
	
	public ComponentDef getComponentDef(int i) {
		return component.get(i);
	}
	
	public Object create(Map<String, Object> property) throws Exception {
		Object newObj = null;
		
		newObj = ClassGenerator.generate(className);
		
		// インタフェースに値を設定する
		
		return newObj;
	}

}
