package org.arefgard.container;

import org.arefgard.container.IllegalReferenceException;

import junit.framework.TestCase;

public class ReferenceTest extends TestCase {

	public void testReference1() {
		try {
			Reference ref = new Reference("service.bean");
			assertEquals("service", ref.getNameSpace());
			assertEquals("bean", ref.getTarget());
			assertEquals("service.bean", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("例外発生" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference2() {
		try {
			Reference ref = new Reference("service");
			assertEquals("service", ref.getNameSpace());
			assertEquals(null, ref.getTarget());
			assertEquals("service", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("例外発生" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference3() {
		try {
			new Reference("service.");
			fail("例外が発生しませんでした");
		} catch (IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference4() {
		try {
			new Reference(".bean");
			fail("例外が発生しませんでした");
		} catch (IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference5() {
		try {
			new Reference("");
			fail("例外が発生しませんでした");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference6() {
		try {
			new Reference(null);
			fail("例外が発生しませんでした");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference7() {
		try {
			Reference ref = new Reference();
			ref.setNameSpace("service");
			ref.setTarget("bean");
			assertEquals("service", ref.getNameSpace());
			assertEquals("bean", ref.getTarget());
			assertEquals("service.bean", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("例外発生" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference8() {
		try {
			Reference ref = new Reference();
			ref.setNameSpace("service");
			assertEquals("service", ref.getNameSpace());
			assertEquals(null, ref.getTarget());
			assertEquals("service", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("例外発生" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference9() {
		try {
			Reference ref = new Reference();
			ref.setTarget("bean");
			assertEquals(null, ref.getNameSpace());
			assertEquals("bean", ref.getTarget());
			ref.getReferencePath();
			fail("例外が発生しませんでした");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
	public void testReference10() {
		try {
			Reference ref = new Reference();
			ref.getReferencePath();
			fail("例外が発生しませんでした");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("想定外の例外が発生しました" + e);
		}
	}
	
}
