package org.arefgard.container.flow.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.arefgard.business.domain.model.Customer;
import org.junit.Test;


public class ServiceWorkflowExecutorTest {

	@Test
	public void executeWorkflow() {
		try {
			ServiceWorkflowExecutor exec = new ServiceWorkflowExecutor("files/test01/signIn.xml");
			Customer customer = new Customer();
			customer.setUserName("hoge");
			customer.setPassword("hoge");
			Customer attestedCustomer = new Customer();
			attestedCustomer.setUserName("hoge");
			attestedCustomer.setPassword("hoge");
			exec.setInput("customer", customer);
			exec.setInput("attestedCustomer", attestedCustomer);
			exec.execute();
			Customer result = (Customer)exec.getOutput("attestedCustomer");
			assertEquals("hoge", result.getUserName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("例外が発生しました" + e);
		}
	}
	
	@Test
	public void executeWorkflow2() {
		try {
			ServiceWorkflowExecutor exec = new ServiceWorkflowExecutor("files/test01/signIn.xml");
			Customer customer = new Customer();
			customer.setUserName("hoge");
			customer.setPassword("hoge");
			Customer attestedCustomer = new Customer();
			attestedCustomer.setUserName("hoge");
			attestedCustomer.setPassword("uhe");
			exec.setInput("customer", customer);
			exec.setInput("attestedCustomer", attestedCustomer);
			exec.execute();
			fail("例外が発生しませんでした");
		}catch(Exception e) {
			assertTrue(true);
		}
	}
	
	
}
