/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.aop;

import java.lang.reflect.Field;

public class FieldStructure {
    private String fieldType;
    private String fieldName;
    private Field field;

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public FieldStructure(String fieldType, String fieldName) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public static FieldStructure[] parse(Class cls) {
        Field[] fields = cls.getDeclaredFields();
        FieldStructure[] structure = new FieldStructure[fields.length];
        int size = fields.length;
        int i = 0;
        while (i < size) {
            fields[i].setAccessible(true);
            String fieldType = FieldStructure.getType(fields[i].getType().getName());
            String fieldName = fields[i].getName();
            FieldStructure fs = new FieldStructure(fieldType, fieldName);
            fs.setField(fields[i]);
            structure[i] = fs;
            ++i;
        }
        return structure;
    }

    private static String getType(String typeName) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        if (typeName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (typeName.equals("byte")) {
            return "java.lang.Byte";
        }
        if (typeName.equals("char")) {
            return "java.lang.Character";
        }
        if (typeName.equals("double")) {
            return "java.lang.Double";
        }
        if (typeName.equals("float")) {
            return "java.lang.Float";
        }
        if (typeName.equals("int")) {
            return "java.lang.Integer";
        }
        if (typeName.equals("long")) {
            return "java.lang.Long";
        }
        if (typeName.equals("short")) {
            return "java.lang.Short";
        }
        if (typeName.equals("void")) {
            return "java.lang.Void";
        }
        return typeName;
    }
}

