/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.flow.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.aop.ClassGenerator;
import org.arefgard.container.aop.MethodInvocation;
import org.arefgard.container.flow.WorkflowExecutor;
import org.arefgard.container.flow.service.Decision;
import org.arefgard.container.flow.service.Interface;
import org.arefgard.container.flow.service.Invoke;
import org.arefgard.container.flow.service.Navigation;
import org.arefgard.container.flow.service.Receive;
import org.arefgard.container.flow.service.Reply;
import org.arefgard.container.flow.service.Sequence;
import org.arefgard.container.flow.service.Throw;
import org.arefgard.container.flow.service.While;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceWorkflowExecutor
implements WorkflowExecutor {
    private Log log = LogFactory.getLog(ServiceWorkflowExecutor.class);
    private static String SEQUENCE_NODE_RECEIVE = "receive";
    private static String SEQUENCE_NODE_INVOKE = "invoke";
    private static String SEQUENCE_NODE_REPLY = "reply";
    private static String SEQUENCE_NODE_THROW = "throw";
    private static String SEQUENCE_NODE_DICISION = "decision";
    private static String SEQUENCE_NODE_WHILE = "while";
    private static String XPATH_NODE_INTERFACE = "/usecase/interfaces/interface";
    private static String XPATH_NODE_SEQUENCE = "/usecase/sequence/child::*";
    private static String XPATH_NODE_PARAMETER = "parameter";
    private static String XPATH_NODE_NAVIGATION = "navigation";
    private static String XPATH_ATTR_NAME = "string(@name)";
    private static String XPATH_ATTR_TYPE = "string(@type)";
    private static String XPATH_ATTR_METHOD = "string(@method)";
    private static String XPATH_ATTR_CONDITION = "string(@condition)";
    private static String XPATH_ATTR_NEXTTO = "string(@nextTo)";
    private XPathExpression XPATH_INTERFACE;
    private XPathExpression XPATH_SEQUENCE;
    private XPathExpression XPATH_PARAMETER;
    private XPathExpression XPATH_NAVIGATION;
    private XPathExpression XPATH_NAME;
    private XPathExpression XPATH_TYPE;
    private XPathExpression XPATH_METHOD;
    private XPathExpression XPATH_CONDITION;
    private XPathExpression XPATH_NEXTTO;
    private Map<String, Interface> input = null;
    private Map<String, Sequence> sequence = null;
    private Map<String, Object> output = null;
    private String flowPath = null;
    private String statringPoint = null;

    public ServiceWorkflowExecutor(String flowPath) {
        this.flowPath = flowPath;
        this.input = new HashMap<String, Interface>();
        this.sequence = new HashMap<String, Sequence>();
        this.output = new HashMap<String, Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            this.XPATH_INTERFACE = xpath.compile(XPATH_NODE_INTERFACE);
            this.XPATH_SEQUENCE = xpath.compile(XPATH_NODE_SEQUENCE);
            this.XPATH_PARAMETER = xpath.compile(XPATH_NODE_PARAMETER);
            this.XPATH_NAVIGATION = xpath.compile(XPATH_NODE_NAVIGATION);
            this.XPATH_NAME = xpath.compile(XPATH_ATTR_NAME);
            this.XPATH_TYPE = xpath.compile(XPATH_ATTR_TYPE);
            this.XPATH_METHOD = xpath.compile(XPATH_ATTR_METHOD);
            this.XPATH_CONDITION = xpath.compile(XPATH_ATTR_CONDITION);
            this.XPATH_NEXTTO = xpath.compile(XPATH_ATTR_NEXTTO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parseWorkflow();
    }

    public void execute() throws Exception {
        Receive start = (Receive)this.sequence.get(this.statringPoint);
        int i = 0;
        while (i < start.getParameterLength()) {
            start.getParameter(i);
            ++i;
        }
        String navi = start.getNextTo();
        this.log.debug((Object)("start:" + navi));
        Object result = null;
        block1: while (true) {
            Object obj;
            Sequence sequenceDef;
            if ((sequenceDef = this.sequence.get(navi)) instanceof Invoke) {
                Invoke invokeDef = (Invoke)sequenceDef;
                obj = this.input.get(invokeDef.getType()).getValue();
                String method = invokeDef.getMethod();
                ArrayList<Object> paramList = new ArrayList<Object>();
                int i2 = 0;
                while (i2 < invokeDef.getParameterLength()) {
                    paramList.add(this.input.get(invokeDef.getParameter(i2)).getValue());
                    ++i2;
                }
                MethodInvocation invokeMethod = new MethodInvocation(obj);
                result = invokeMethod.execute(method, paramList);
                navi = invokeDef.getNextTo();
                this.log.debug((Object)("invoke:" + navi));
                continue;
            }
            if (sequenceDef instanceof Reply) {
                Reply replyDef = (Reply)sequenceDef;
                int i3 = 0;
                while (i3 < replyDef.getParameterLength()) {
                    String param = replyDef.getParameter(i3);
                    this.output.put(param, this.input.get(param).getValue());
                    ++i3;
                }
                break;
            }
            if (sequenceDef instanceof Throw) {
                Throw throwDef = (Throw)sequenceDef;
                obj = ClassGenerator.generate(throwDef.getType());
                this.log.debug((Object)"throw");
                throw (Exception)obj;
            }
            if (sequenceDef instanceof Decision) {
                Decision decisionDef = (Decision)sequenceDef;
                Navigation[] navis = decisionDef.getAllNavigations();
                int i4 = 0;
                int n = navis.length;
                while (true) {
                    if (i4 >= n) continue block1;
                    String left = navis[i4].getLeft();
                    String expr = navis[i4].getExpr();
                    String right = navis[i4].getRight();
                    if (left.equals("@return") && result instanceof Boolean) {
                        if (expr.equals("==") && right.equals("true") || expr.equals("!=") && right.equals("false")) {
                            if (((Boolean)result).booleanValue()) {
                                navi = navis[i4].getNextTo();
                                continue block1;
                            }
                        } else if (!((Boolean)result).booleanValue()) {
                            navi = navis[i4].getNextTo();
                            continue block1;
                        }
                    }
                    ++i4;
                }
            }
            boolean cfr_ignored_0 = sequenceDef instanceof While;
        }
        this.log.debug((Object)"reply");
    }

    public Object getOutput(String key) {
        return this.output.get(key);
    }

    public void setInput(String key, Object obj) {
        Interface interfaceDef = this.input.get(key);
        interfaceDef.setValue(obj);
        this.input.put(key, interfaceDef);
    }

    private void parseWorkflow() {
        int i;
        InputStream is = ClassLoader.getSystemResourceAsStream(this.flowPath);
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (Exception builder) {
            // empty catch block
        }
        try {
            NodeList interfaces = (NodeList)this.XPATH_INTERFACE.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            while (i < interfaces.getLength()) {
                Node interfaceNode = interfaces.item(i);
                String name = this.getName(interfaceNode);
                String type = this.getType(interfaceNode);
                Interface interfaceDef = new Interface(name, type);
                this.input.put(name, interfaceDef);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NodeList sequences = (NodeList)this.XPATH_SEQUENCE.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            while (i < sequences.getLength()) {
                String type;
                String param;
                int j;
                NodeList parameters;
                String name;
                Node sequenceNode = sequences.item(i);
                String nodeName = sequenceNode.getNodeName();
                if (nodeName.endsWith(SEQUENCE_NODE_RECEIVE)) {
                    name = this.getName(sequenceNode);
                    Receive receiveDef = new Receive(name);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    j = 0;
                    while (j < parameters.getLength()) {
                        Node parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        receiveDef.addParameter(param);
                        ++j;
                    }
                    receiveDef.setNextTo(this.getNextTo(sequenceNode));
                    this.sequence.put(name, receiveDef);
                    this.statringPoint = name;
                } else if (nodeName.endsWith(SEQUENCE_NODE_INVOKE)) {
                    name = this.getName(sequenceNode);
                    type = this.getType(sequenceNode);
                    String method = this.getMethod(sequenceNode);
                    Invoke invokeDef = new Invoke(name, type, method);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    j = 0;
                    while (j < parameters.getLength()) {
                        Node parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        invokeDef.addParameter(param);
                        ++j;
                    }
                    invokeDef.setNextTo(this.getNextTo(sequenceNode));
                    this.sequence.put(name, invokeDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_REPLY)) {
                    name = this.getName(sequenceNode);
                    Reply replyDef = new Reply(name);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    j = 0;
                    while (j < parameters.getLength()) {
                        Node parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        replyDef.addParameter(param);
                        ++j;
                    }
                    this.sequence.put(name, replyDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_THROW)) {
                    name = this.getName(sequenceNode);
                    type = this.getType(sequenceNode);
                    Throw throwDef = new Throw(name, type);
                    this.sequence.put(name, throwDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_DICISION)) {
                    name = this.getName(sequenceNode);
                    Decision decisionDef = new Decision(name);
                    NodeList navigations = (NodeList)this.XPATH_NAVIGATION.evaluate(sequenceNode, XPathConstants.NODESET);
                    j = 0;
                    int n = navigations.getLength();
                    while (j < n) {
                        Node navi = navigations.item(j);
                        String condition = this.getCondition(navi);
                        String nextTo = this.getNextTo(navi);
                        decisionDef.addNavigation(new Navigation(condition, nextTo));
                        ++j;
                    }
                    this.sequence.put(name, decisionDef);
                } else {
                    nodeName.endsWith(SEQUENCE_NODE_WHILE);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getName(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_NAME.evaluate(obj, XPathConstants.STRING);
    }

    private String getType(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_TYPE.evaluate(obj, XPathConstants.STRING);
    }

    private String getMethod(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_METHOD.evaluate(obj, XPathConstants.STRING);
    }

    private String getCondition(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_CONDITION.evaluate(obj, XPathConstants.STRING);
    }

    private String getNextTo(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_NEXTTO.evaluate(obj, XPathConstants.STRING);
    }
}

