package org.arefgard.container;

import java.util.Map;

import org.arefgard.container.aop.ClassGenerator;

/**
 * <bean/>の定義を保持しているクラス。
 * 
 * @author T.A.K.A.Dark
 */
public class BeanDef {
	
	/** bean名 */
	private String name;
	/** Javaクラス */
	private String className;
	/** 対応するテーブル */
	private String table;
	
	/** beanが保持しているプロパティ */
	private Map<String, PropertyDef> property;
	
	/**
	 * コンストラクタ。
	 * 
	 * @param name bean名
	 * @param className Javaクラス
	 * @throws ContainerException
	 */
	public BeanDef(String name, String className) throws ContainerException {
		property = new java.util.HashMap<String, PropertyDef>();
		this.name = name;
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public void addProperty(PropertyDef propertyDef) {
		this.property.put(propertyDef.getName(), propertyDef);
	}
	
	public PropertyDef getProperty(String name) {
		return this.property.get(name);
	}
	
	public PropertyDef[] getAllProperties() {
		return this.property.values().toArray(new PropertyDef[0]);
	}
	
	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}
	
	/**
	 * bean情報およびプロパティに対応する値を使ってオブジェクトを生成する。
	 * プロパティがnullまたは空の場合は、オブジェクトの生成のみ行う。
	 * 
	 * @param property 生成したオブジェクトに設定するプロパティ
	 * @return 生成したオブジェクト
	 * @throws Exception
	 */
	public Object create(Map<String, Object> property) throws Exception {
		Object newObj = null;
		try {
			if(property != null && property.size() != 0) {
				newObj = ClassGenerator.generate(className, property);
			}else {
				newObj = ClassGenerator.generate(className);
			}
		}catch(Exception e) {
			
		}
		return newObj;
	}
}
