package org.arefgard.container;

import java.util.Map;

/**
 * Icerya Container Interface.
 * 
 * @author T.A.K.A.Dark
 */
public interface IceryaContainer {
	
	/**
	 * Creates a new instance of the class represented by <tt>container definition file</tt>.
	 * The class is instantiated as if by a new expression with an empty argument list.
	 * 
	 * @param ref object reference path in container definition file.
	 * @return a newly allocated instance.
	 * @throws ContainerException if the instantiation fails for some reason.
	 */
	Object create(String ref) throws ContainerException;
	
	/**
	 * Creates a new instnace of the class represented by "container definition file".
	 * The class is instantiated as if by a new expression with an empty argument list.
	 * 
	 * @param ref object reference path in container definition file.
	 * @param arguments argument list.
	 * @return a newly allocated instance.
	 * @throws ContainerException if the instantiation fails for some reason.
	 */
	Object create(String ref, Map<String, Object> arguments) throws ContainerException;
	
	/**
	 * Creates a new instnace of the class represented by "container definition file".
	 * The class is instantiated as if by a new expression with an empty argument list.
	 * 
	 * @param ref object reference in container definition file.
	 * @return a newly argument list.
	 * @throws ContainerException if the instantiation fails for some reason.
	 */
	Object create(Reference ref) throws ContainerException;
	
	Object create(Reference ref, Map<String, Object> property) throws ContainerException;
	Object create(Class clazz) throws ContainerException;
	
	BusinessService createService(String ref) throws ContainerException;
	
	/**
	 * コンテナにオブジェクトを保存する。
	 * 
	 * @param obj
	 * @throws ContainerException
	 */
	void persist(Object obj) throws ContainerException;
	
	/**
	 * キーを使ってコンテナに保存していたオブジェクトを読み出す。
	 * 
	 * @param key
	 * @return
	 * @throws ContainerException
	 */
	Object load(String key) throws ContainerException;
	
	/**
	 * 条件に合うオブジェクトを取得する。
	 * @param query
	 * @return
	 * @throws ContainerException
	 */
	Object[] find(String query) throws ContainerException;
	
	/**
	 *  サービス定義を取得する。
	 */
	BusinessDef getBusinessDef(String key);
	
	/**
	 * サービス定義を追加する。
	 */
	void addBusinessDef(BusinessDef service);
	
	/**
	 * ドメイン定義を取得する。
	 */
	DomainDef getDomainDef(String key);
	
	/**
	 * ドメイン定義を追加する。
	 * @param domain
	 */
	void addDomainDef(DomainDef domain);
	
	void setConnectionDef(ConnectionDef connection);
	
	ConnectionDef getConnectionDef();
	
}
