package org.arefgard.container.orm;

import java.sql.Connection;
import java.sql.DriverManager;

/**
 * Sessionを生成するファクトリ。
 * 
 * @author T.A.K.A.Dark
 */
public class SessionFactory {
	
	/** コネクション */
	private static Connection conn = null;
	
	/**
	 * ファクトリを初期化する。
	 * 
	 * @param driver JDBCドライバ
	 * @param url 接続URL
	 * @param user 接続ユーザ
	 * @param password パスワード
	 */
	public synchronized static void initialize(String driver, String url, String user, String password) {
		try {
			Class.forName(driver);
			conn = DriverManager.getConnection(url + "?user=" + user + "&password=" + password);
		}catch(Exception e) {
			
		}
	}
	
	/**
	 * Sessionを開く。
	 * 
	 * @return 開いたSession
	 */
	public static Session openSession() {
		return new Session(conn);
	}
}
