package org.arefgard.container.flow.service;

import static org.junit.Assert.assertEquals;

import org.junit.Test;


public class NavigationTest {

	@Test
	public void perseCondition01() {
		Navigation navi = new Navigation("LEFT==RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("==", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());
	}
	
	@Test
	public void perseCondition02() {
		Navigation navi = new Navigation("LEFT<RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("<", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition03() {
		Navigation navi = new Navigation("LEFT<=RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("<=", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition04() {
		Navigation navi = new Navigation("LEFT>RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals(">", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition05() {
		Navigation navi = new Navigation("LEFT>=RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals(">=", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition06() {
		Navigation navi = new Navigation("LEFT!=RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("!=", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
}
