/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arefgard.container.ComponentDef;
import org.arefgard.container.ContainerException;
import org.arefgard.container.FlowDef;
import org.arefgard.container.InputDef;
import org.arefgard.container.OutputDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDef {
    private String name;
    private Map<String, InputDef> input;
    private List<ComponentDef> component;
    private FlowDef flow;
    private List<OutputDef> output;
    private String className;

    public ServiceDef(String name) throws ContainerException {
        this.name = name;
        this.input = new HashMap<String, InputDef>();
        this.component = new ArrayList<ComponentDef>();
        this.output = new ArrayList<OutputDef>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addInputDef(InputDef inputDef) {
        this.input.put(inputDef.getName(), inputDef);
    }

    public InputDef getInputDef(String name) {
        return this.input.get(name);
    }

    public void addOutputDef(OutputDef outputDef) {
        this.output.add(outputDef);
    }

    public int getOutputLength() {
        return this.output.size();
    }

    public OutputDef getOutputDef(int i) {
        return this.output.get(i);
    }

    public void setFlowDef(FlowDef flowDef) {
        this.flow = flowDef;
    }

    public FlowDef getFlowDef() {
        return this.flow;
    }

    public void addComponentDef(ComponentDef componentDef) {
        this.component.add(componentDef);
    }

    public int getComponentDefLength() {
        return this.component.size();
    }

    public ComponentDef getComponentDef(int i) {
        return this.component.get(i);
    }

    public List<String> getInputs() {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> keys = this.input.keySet();
        Iterator<String> itr = keys.iterator();
        while (itr.hasNext()) {
            result.add(itr.next());
        }
        return result;
    }

    public List<String> getOutputs() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int n = this.output.size();
        while (i < n) {
            result.add(this.output.get(i).getName());
            ++i;
        }
        return result;
    }
}

