/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.BusinessDef;
import org.arefgard.container.BusinessService;
import org.arefgard.container.ContainerException;
import org.arefgard.container.ContainerFactory;
import org.arefgard.container.IceryaContainer;
import org.arefgard.container.Reference;
import org.arefgard.container.ServiceDef;
import org.arefgard.container.ServiceDelegate;
import org.arefgard.container.trans.StructureTransformer;

public class ServiceDelegateLocal
implements ServiceDelegate {
    private Log log = LogFactory.getLog(ServiceDelegateLocal.class);
    private Map<String, Object> inputComponent = new HashMap<String, Object>();
    private StructureTransformer trans = null;
    private BusinessService businessService = null;

    protected ServiceDelegateLocal(String path) {
        try {
            this.trans = new StructureTransformer(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute(String service) throws ContainerException {
        Set<String> keys = this.inputComponent.keySet();
        for (String key : keys) {
            this.trans.addComponent(key, this.inputComponent.get(key));
        }
        String uri = this.trans.getUri();
        ContainerFactory.initialize(uri);
        IceryaContainer container = ContainerFactory.newContainer();
        this.businessService = container.createService("account.signIn");
        Reference ref = new Reference(service);
        BusinessDef businessDef = container.getBusinessDef(ref.getNameSpace());
        ServiceDef serviceDef = businessDef.getServiceDef(ref.getTarget());
        List<String> inputs = serviceDef.getInputs();
        try {
            int i = 0;
            int n = inputs.size();
            while (i < n) {
                this.businessService.addInput(inputs.get(i), this.trans.transform(inputs.get(i)));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)"error", (Throwable)e);
            throw new ContainerException("", e);
        }
        try {
            this.businessService.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.trans.clear();
        Map<String, Object> outputs = this.businessService.getOutputs();
        Set<String> key = outputs.keySet();
        for (String name : key) {
            this.trans.addComponent(name, outputs.get(name));
        }
    }

    public void addComponent(String name, Object obj) {
        this.inputComponent.put(name, obj);
    }

    public Object getComponent(String name) throws ContainerException {
        Object result = null;
        try {
            result = this.trans.transform(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ContainerException("", e);
        }
        return result;
    }
}

