/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.trans;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.ContainerException;
import org.arefgard.container.aop.ClassGenerator;
import org.arefgard.container.aop.MethodInvocation;
import org.arefgard.container.trans.Component;
import org.arefgard.container.trans.Mapping;
import org.arefgard.container.util.MessageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructureTransformer {
    private static Log log = LogFactory.getLog(StructureTransformer.class);
    private static String XPATH_NODE_COMPONENT = "/transform/components/component";
    private static String XPATH_NODE_MAPPING = "/transform/mappings/mapping";
    private static String XPATH_NODE_PROPERTY = "property";
    private static String XPATH_ATTR_NAME = "string(@name)";
    private static String XPATH_ATTR_TYPE = "string(@type)";
    private static String XPATH_ATTR_URI = "string(/transform/mappings/@uri)";
    private static String XPATH_ATTR_TEXT = "text()";
    private static XPathExpression XPATH_COMPONENT;
    private static XPathExpression XPATH_MAPPING;
    private static XPathExpression XPATH_PROPERTY;
    private static XPathExpression XPATH_NAME;
    private static XPathExpression XPATH_TYPE;
    private static XPathExpression XPATH_URI;
    private static XPathExpression XPATH_TEXT;
    private String uri = null;
    private Map<String, Component> components = new HashMap<String, Component>();
    private Map<String, Mapping> mappings = new HashMap<String, Mapping>();
    private Map<String, Object> before = new HashMap<String, Object>();
    private Map<String, Object> after = new HashMap<String, Object>();

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            XPATH_COMPONENT = xpath.compile(XPATH_NODE_COMPONENT);
            XPATH_MAPPING = xpath.compile(XPATH_NODE_MAPPING);
            XPATH_PROPERTY = xpath.compile(XPATH_NODE_PROPERTY);
            XPATH_NAME = xpath.compile(XPATH_ATTR_NAME);
            XPATH_TYPE = xpath.compile(XPATH_ATTR_TYPE);
            XPATH_URI = xpath.compile(XPATH_ATTR_URI);
            XPATH_TEXT = xpath.compile(XPATH_ATTR_TEXT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public StructureTransformer(String path) throws ContainerException {
        String name;
        int n;
        int i;
        log.info((Object)MessageUtil.getMessage("TRANSFORM.INFO.LOADFILE", path));
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        if (is == null) {
            throw new ContainerException(MessageUtil.getMessage("CONTAINER.ERROR.NOTFOUND", path));
        }
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (Exception e) {
            throw new ContainerException("", e);
        }
        try {
            NodeList componentNodes = (NodeList)XPATH_COMPONENT.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            n = componentNodes.getLength();
            while (i < n) {
                Node componentNode = componentNodes.item(i);
                name = (String)XPATH_NAME.evaluate(componentNode, XPathConstants.STRING);
                String type = (String)XPATH_TYPE.evaluate(componentNode, XPathConstants.STRING);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8:" + name + "," + type));
                }
                Component component = new Component();
                component.setName(name);
                component.setType(type);
                this.components.put(name, component);
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new ContainerException("", e);
        }
        try {
            NodeList mappingNodes = (NodeList)XPATH_MAPPING.evaluate(doc, XPathConstants.NODESET);
            this.uri = (String)XPATH_URI.evaluate(doc, XPathConstants.STRING);
            i = 0;
            n = mappingNodes.getLength();
            while (i < n) {
                String context;
                Node mappingNode = mappingNodes.item(i);
                name = (String)XPATH_NAME.evaluate(mappingNode, XPathConstants.STRING);
                Mapping mapping = new Mapping();
                mapping.setName(name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u30de\u30c3\u30d4\u30f3\u30b0:" + name));
                }
                if ((context = ((String)XPATH_TEXT.evaluate(mappingNode, XPathConstants.STRING)).trim()) == null || context.equals("")) {
                    NodeList propertyNodes = (NodeList)XPATH_PROPERTY.evaluate(mappingNode, XPathConstants.NODESET);
                    int j = 0;
                    int m = propertyNodes.getLength();
                    while (j < m) {
                        Node propertyNode = propertyNodes.item(j);
                        String propName = (String)XPATH_NAME.evaluate(propertyNode, XPathConstants.STRING);
                        String propText = (String)XPATH_TEXT.evaluate(propertyNode, XPathConstants.STRING);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u30d7\u30ed\u30d1\u30c6\u30a3:" + propName + "," + propText));
                        }
                        mapping.setProperty(propName, propText);
                        ++j;
                    }
                } else {
                    mapping.setContext(context);
                }
                this.mappings.put(name, mapping);
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new ContainerException("", e);
        }
    }

    public void addComponent(String name, Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306e\u8ffd\u52a0\uff1a" + name));
        }
        Component component = this.components.get(name);
        this.before.put(component.getName(), obj);
    }

    public Object transform(String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5909\u63db\u5f8c\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u540d\uff1a" + name));
        }
        Mapping mapping = this.mappings.get(name);
        Component component = this.components.get(mapping.getName());
        Object obj = ClassGenerator.generate(component.getType());
        MethodInvocation afterInvoke = new MethodInvocation(obj);
        String context = mapping.getContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\uff1a" + context));
        }
        boolean skip = false;
        if (context == null || context.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u3088\u308b\u8a2d\u5b9a");
            }
            String[] values = mapping.getAllKeys();
            int i = 0;
            int n = values.length;
            while (i < n) {
                String propName = values[i];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u30ad\u30fc\uff1a" + propName));
                }
                StringTokenizer tokenizer = new StringTokenizer(mapping.getProperty(propName), ".");
                String componentRef = tokenizer.nextToken();
                String method = tokenizer.nextToken();
                Object componentObj = this.before.get(componentRef);
                if (componentObj == null) {
                    skip = true;
                    break;
                }
                MethodInvocation beforeInvoke = new MethodInvocation(componentObj);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(propName) + "," + beforeInvoke.getProperty(method)));
                }
                afterInvoke.setProperty(propName, beforeInvoke.getProperty(method));
                ++i;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u306b\u3088\u308b\u8a2d\u5b9a");
            }
            StringTokenizer tokenizer = new StringTokenizer(context, ".");
            String componentRef = tokenizer.nextToken();
            String method = tokenizer.nextToken();
            Object componentObj = this.before.get(componentRef);
            if (componentObj == null) {
                skip = true;
            } else {
                MethodInvocation beforeInvoke = new MethodInvocation(componentObj);
                obj = beforeInvoke.getProperty(method);
            }
        }
        if (skip) {
            return null;
        }
        return obj;
    }

    public Object getComponent(String name) {
        return this.after.get(name);
    }

    public String getUri() {
        return this.uri;
    }

    public void clear() {
        this.before.clear();
        this.after.clear();
    }
}

