package org.arefgard.container;

import java.util.Map;

import org.arefgard.container.aop.ClassGenerator;

public class BeanDef {
	
	private String name;
	private String className;
	private String table;
	
	private Map<String, PropertyDef> property;
	
	public BeanDef(String name, String className) throws ContainerException {
		property = new java.util.HashMap<String, PropertyDef>();
		this.name = name;
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public void addProperty(PropertyDef propertyDef) {
		this.property.put(propertyDef.getName(), propertyDef);
	}
	
	public PropertyDef getProperty(String name) {
		return this.property.get(name);
	}
	
	public PropertyDef[] getAllProperties() {
		return this.property.values().toArray(new PropertyDef[0]);
	}
	
	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}
	
	public Object create(Map<String, Object> property) throws ContainerException {
		Object newObj = null;
		try {
			if(property != null && property.size() != 0) {
				newObj = ClassGenerator.generate(className, property);
			}else {
				newObj = ClassGenerator.generate(className);
			}
		}catch(Exception e) {
			e.printStackTrace();
			throw new ComponentGenerationException("", e);
		}
		return newObj;
	}
}
