package org.arefgard.container;

import java.util.Map;

public interface IceryaContainer {
	
	Object create(String ref) throws ContainerException;
	
	Object create(String ref, Map<String, Object> arguments) throws ContainerException;
	
	Object create(Reference ref) throws ContainerException;
	
	Object create(Reference ref, Map<String, Object> property) throws ContainerException;
	Object create(Class clazz) throws ContainerException;
	
	BusinessService createService(String ref) throws ContainerException;
	
	void persist(Object obj) throws ContainerException;
	
	Object load(String key) throws ContainerException;
	
	Object[] find(String query) throws ContainerException;
	
	BusinessDef getBusinessDef(String key);
	
	void addBusinessDef(BusinessDef service);
	
	DomainDef getDomainDef(String key);
	
	void addDomainDef(DomainDef domain);
	
	void setConnectionDef(ConnectionDef connection);
	
	ConnectionDef getConnectionDef();
	
}
