package org.arefgard.container;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceDef {

	private String name;
	private Map<String, InputDef> input;
	private List<ComponentDef> component;
	private FlowDef flow;
	private List<OutputDef> output;
	private String className;
	
	public ServiceDef(String name) throws ContainerException {
		this.name = name;
		input = new java.util.HashMap<String, InputDef>();
		component = new java.util.ArrayList<ComponentDef>();
		output = new java.util.ArrayList<OutputDef>();
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}
	
	public void addInputDef(InputDef inputDef) {
		input.put(inputDef.getName(), inputDef);
	}
	
	public InputDef getInputDef(String name) {
		return input.get(name);
	}
	
	public void addOutputDef(OutputDef outputDef) {
		output.add(outputDef);
	}
	
	public int getOutputLength() {
		return this.output.size();
	}
	
	public OutputDef getOutputDef(int i) {
		return this.output.get(i);
	}
	
	public void setFlowDef(FlowDef flowDef) {
		this.flow = flowDef;
	}
	
	public FlowDef getFlowDef() {
		return this.flow;
	}
	
	public void addComponentDef(ComponentDef componentDef) {
		component.add(componentDef);
	}
	
	public int getComponentDefLength() {
		return component.size();
	}
	
	public ComponentDef getComponentDef(int i) {
		return component.get(i);
	}
	
	public List<String> getInputs() {
		List<String> result = new java.util.ArrayList<String>();
		Set<String> keys = input.keySet();
		for(Iterator<String> itr = keys.iterator(); itr.hasNext();) {
			result.add(itr.next());
		}
		return result;
	}
	
	public List<String> getOutputs() {
		List<String> result = new java.util.ArrayList<String>();
		for(int i = 0, n = output.size(); i < n; i++) {
			result.add(output.get(i).getName());
		}
		return result;
	}

}
