package org.arefgard.container;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.trans.StructureTransformer;

public class ServiceDelegateLocal implements ServiceDelegate {

	private Log log = LogFactory.getLog(ServiceDelegateLocal.class);
	
	private Map<String, Object> inputComponent = new java.util.HashMap<String, Object>();
	
	private StructureTransformer trans = null;
	private BusinessService businessService = null;
	
	protected ServiceDelegateLocal(String path) {
		try {
			trans = new StructureTransformer(path);
		}catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public void execute(String service) throws ContainerException {
		Set<String> keys = this.inputComponent.keySet();
		for(Iterator<String> itr = keys.iterator();itr.hasNext();) {
			String key = itr.next();
			trans.addComponent(key, this.inputComponent.get(key));
		}
		
		String uri = trans.getUri();
		
		ContainerFactory.initialize(uri);
		IceryaContainer container = ContainerFactory.newContainer();
		
		businessService = container.createService("account.signIn");
		
		Reference ref = new Reference(service);
		BusinessDef businessDef = container.getBusinessDef(ref.getNameSpace());
		ServiceDef serviceDef = businessDef.getServiceDef(ref.getTarget());
		List<String> inputs = serviceDef.getInputs();
		try {
			for(int i = 0, n = inputs.size(); i < n; i++) {
				businessService.addInput(inputs.get(i), trans.transform(inputs.get(i)));
			}
		}catch(Exception e) {
			e.printStackTrace();
			log.error("error", e);
			throw new ContainerException("", e);
		}
		
		try {
			businessService.execute();
		}catch(Exception e) {
			e.printStackTrace();
		}
		
		trans.clear();
		
		Map<String, Object> outputs = businessService.getOutputs();
		Set<String> key = outputs.keySet();
		
		for(Iterator<String> itr = key.iterator(); itr.hasNext();) {
			String name = itr.next();
			trans.addComponent(name, outputs.get(name));
		}
	}
	
	public void addComponent(String name, Object obj) {
		this.inputComponent.put(name, obj);
	}
	
	public Object getComponent(String name) throws ContainerException {
		Object result = null;
		try {
			result = trans.transform(name);
		}catch(Exception e) {
			e.printStackTrace();
			throw new ContainerException("", e);
		}
		return result;
	}

}
