package org.arefgard.container.trans;

import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.Constants;
import org.arefgard.container.ContainerException;
import org.arefgard.container.aop.ClassGenerator;
import org.arefgard.container.aop.MethodInvocation;
import org.arefgard.container.util.MessageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructureTransformer {
	private static Log log = LogFactory.getLog(StructureTransformer.class);
	
	private static String XPATH_NODE_COMPONENT = "/transform/components/component";
	private static String XPATH_NODE_MAPPING = "/transform/mappings/mapping";
	private static String XPATH_NODE_PROPERTY = "property";
	
	private static String XPATH_ATTR_NAME = "string(@name)";
	private static String XPATH_ATTR_TYPE = "string(@type)";
	private static String XPATH_ATTR_URI = "string(/transform/mappings/@uri)";
	private static String XPATH_ATTR_TEXT = "text()";
	
	private static XPathExpression XPATH_COMPONENT;
	private static XPathExpression XPATH_MAPPING;
	private static XPathExpression XPATH_PROPERTY;
	
	private static XPathExpression XPATH_NAME;
	private static XPathExpression XPATH_TYPE;
	private static XPathExpression XPATH_URI;
	private static XPathExpression XPATH_TEXT;
	
	private String uri = null;
	private Map<String, Component> components = new java.util.HashMap<String, Component>();
	private Map<String, Mapping> mappings = new java.util.HashMap<String, Mapping>();
	
	private Map<String, Object> before = new java.util.HashMap<String, Object>();
	private Map<String, Object>	after = new java.util.HashMap<String, Object>();
	
	static {
		XPathFactory factory = XPathFactory.newInstance();
		XPath xpath = factory.newXPath();
		try {
			XPATH_COMPONENT = xpath.compile(XPATH_NODE_COMPONENT);
			XPATH_MAPPING = xpath.compile(XPATH_NODE_MAPPING);
			XPATH_PROPERTY = xpath.compile(XPATH_NODE_PROPERTY);
			
			XPATH_NAME = xpath.compile(XPATH_ATTR_NAME);
			XPATH_TYPE = xpath.compile(XPATH_ATTR_TYPE);
			XPATH_URI = xpath.compile(XPATH_ATTR_URI);
			XPATH_TEXT = xpath.compile(XPATH_ATTR_TEXT);
		}catch(Exception e) {
			
		}
		
	}
	
	public StructureTransformer(String path) throws ContainerException {
		log.info(MessageUtil.getMessage(Constants.TRANSFORM_INFO_LOADFILE, path));
		
		InputStream is = ClassLoader.getSystemResourceAsStream(path);
		if(is == null) {
			is = this.getClass().getClassLoader().getResourceAsStream(path);
		}
		if(is == null) {
			throw new ContainerException(MessageUtil.getMessage(Constants.CONTAINER_ERROR_NOTFOUND, path));
		}
		
		DocumentBuilderFactory factory;
		Document doc = null;
		try {
			factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			doc = builder.parse(is);
		}catch(Exception e) {
			throw new ContainerException("", e);
		}
		
		// R|[lg̃p[X
		try {
			NodeList componentNodes = (NodeList)XPATH_COMPONENT.evaluate(doc, XPathConstants.NODESET);
			for(int i = 0, n = componentNodes.getLength(); i < n; i++) {
				Node componentNode = componentNodes.item(i);
				String name = (String)XPATH_NAME.evaluate(componentNode, XPathConstants.STRING);
				String type = (String)XPATH_TYPE.evaluate(componentNode, XPathConstants.STRING);
				if(log.isDebugEnabled()) {
					log.debug("R|[lg:" +name + "," + type);
				}
				Component component = new Component();
				component.setName(name);
				component.setType(type);
				components.put(name, component);
			}
		}catch(Exception e) {
			log.error("error", e);
			throw new ContainerException("", e);
		}
		// }bsÕp[X
		try {
			NodeList mappingNodes = (NodeList)XPATH_MAPPING.evaluate(doc, XPathConstants.NODESET);
			this.uri = (String)XPATH_URI.evaluate(doc, XPathConstants.STRING);
			for(int i = 0, n = mappingNodes.getLength(); i < n; i++) {
				Node mappingNode = mappingNodes.item(i);
				String name = (String)XPATH_NAME.evaluate(mappingNode, XPathConstants.STRING);
				Mapping mapping = new Mapping();
				mapping.setName(name);
				if(log.isDebugEnabled()) {
					log.debug("}bsO:" +name);
				}
				String context = ((String)XPATH_TEXT.evaluate(mappingNode, XPathConstants.STRING)).trim();
				if(context == null || context.equals("")) {
					NodeList propertyNodes = (NodeList)XPATH_PROPERTY.evaluate(mappingNode, XPathConstants.NODESET);
					for(int j = 0, m = propertyNodes.getLength(); j < m; j++) {
						Node propertyNode = propertyNodes.item(j);
						String propName = (String)XPATH_NAME.evaluate(propertyNode, XPathConstants.STRING);
						String propText = (String)XPATH_TEXT.evaluate(propertyNode, XPathConstants.STRING);
						if(log.isDebugEnabled()) {
							log.debug("vpeB:" + propName + "," + propText);
						}
						mapping.setProperty(propName, propText);
					}
				}else {
					mapping.setContext(context);
				}
				mappings.put(name, mapping);
			}
		}catch(Exception e) {
			log.error("error", e);
			throw new ContainerException("", e);
		}
	}
	
	public void addComponent(String name, Object obj) {
		if(log.isDebugEnabled()) {
			log.debug("R|[lg̒ǉF" + name);
		}
		Component component = components.get(name);
		this.before.put(component.getName(), obj);
	}
	
	public Object transform(String name) throws Exception {
		if(log.isDebugEnabled()) {
			log.debug("ϊR|[lgF" + name);
		}
		Mapping mapping = mappings.get(name);
		Component component = this.components.get(mapping.getName());
		Object obj = ClassGenerator.generate(component.getType());
		MethodInvocation afterInvoke = new MethodInvocation(obj);
		String context = mapping.getContext();
		if(log.isDebugEnabled()) {
			log.debug("ReLXgF" + context);
		}
		boolean skip = false;
		if(context == null || context.equals("")) {
			if(log.isDebugEnabled()) {
				log.debug("vpeBɂݒ");
			}
			String[] values = mapping.getAllKeys();
			for(int i = 0, n = values.length; i < n; i++) {
				String propName = values[i];
				if(log.isDebugEnabled()) {
					log.debug("L[F" + propName);
				}
				StringTokenizer tokenizer = new StringTokenizer(mapping.getProperty(propName), ".");
				String componentRef = tokenizer.nextToken();
				String method = tokenizer.nextToken();
				Object componentObj = before.get(componentRef);
				if(componentObj == null) {
					skip = true;
					break;
				}
				MethodInvocation beforeInvoke = new MethodInvocation(componentObj);
				if(log.isDebugEnabled()) {
					log.debug(propName + "," + beforeInvoke.getProperty(method));
				}
				afterInvoke.setProperty(propName, beforeInvoke.getProperty(method));
			}
		}else {
			if(log.isDebugEnabled()) {
				log.debug("ReLXgɂݒ");
			}
			StringTokenizer tokenizer = new StringTokenizer(context, ".");
			String componentRef = tokenizer.nextToken();
			String method = tokenizer.nextToken();
			Object componentObj = before.get(componentRef);
			if(componentObj == null) {
				skip = true;
			}else {
				MethodInvocation beforeInvoke = new MethodInvocation(componentObj);
				obj = beforeInvoke.getProperty(method);
			}
		}
		if(skip == true) {
			return null;
		}else {
			return obj;
		}
		
	}
	
	public Object getComponent(String name) {
		return this.after.get(name);
	}
	
	public String getUri() {
		return this.uri;
	}
	
	public void clear() {
		this.before.clear();
		this.after.clear();
	}
	
}
