package org.arefgard.container;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.arefgard.container.IllegalReferenceException;
import org.junit.Test;

public class ReferenceTest {

	@Test
	public void testReference1() {
		try {
			Reference ref = new Reference("service.bean");
			assertEquals("service", ref.getNameSpace());
			assertEquals("bean", ref.getTarget());
			assertEquals("service.bean", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("error" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference2() {
		try {
			Reference ref = new Reference("service");
			assertEquals("service", ref.getNameSpace());
			assertEquals(null, ref.getTarget());
			assertEquals("service", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("error" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference3() {
		try {
			new Reference("service.");
			fail("error");
		} catch (IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference4() {
		try {
			new Reference(".bean");
			fail("error");
		} catch (IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference5() {
		try {
			new Reference("");
			fail("error");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference6() {
		try {
			new Reference(null);
			fail("error");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference7() {
		try {
			Reference ref = new Reference();
			ref.setNameSpace("service");
			ref.setTarget("bean");
			assertEquals("service", ref.getNameSpace());
			assertEquals("bean", ref.getTarget());
			assertEquals("service.bean", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("error" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference8() {
		try {
			Reference ref = new Reference();
			ref.setNameSpace("service");
			assertEquals("service", ref.getNameSpace());
			assertEquals(null, ref.getTarget());
			assertEquals("service", ref.getReferencePath());
		}catch(IllegalReferenceException e) {
			e.printStackTrace();
			fail("error" + e);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference9() {
		try {
			Reference ref = new Reference();
			ref.setTarget("bean");
			assertEquals(null, ref.getNameSpace());
			assertEquals("bean", ref.getTarget());
			ref.getReferencePath();
			fail("error");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void testReference10() {
		try {
			Reference ref = new Reference();
			ref.getReferencePath();
			fail("error");
		}catch(IllegalReferenceException e) {
			assertTrue(true);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
}
