package org.arefgard.container;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.arefgard.business.domain.action.LoginForm;
import org.junit.Test;

public class ServiceDelegateLocalTest {

	@Test
	public void executeService() {
		ServiceDelegate delegate = ServiceDelegateFactory.newServiceDelegate("files/test03/transform.xml");
		LoginForm form = new LoginForm();
		form.setId("00001");
		form.setPassword("p@ssw0rd");
		try {
			delegate.addComponent("loginForm", form);
			delegate.execute("account.signIn");
			assertEquals("00001", delegate.getComponent("customerId2"));
			assertEquals("p@ssw0rd", delegate.getComponent("password2"));
		}catch(Exception e) {
			e.printStackTrace();
			fail("");
		}
	}
}
