package org.arefgard.container.flow;

import static org.junit.Assert.assertEquals;

import org.arefgard.container.flow.Navigation;
import org.junit.Test;


public class NavigationTest {

	@Test
	public void perseCondition01() {
		Navigation navi = new Navigation("LEFT==RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("==", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());
	}
	
	@Test
	public void perseCondition02() {
		Navigation navi = new Navigation("LEFT<RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("<", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition03() {
		Navigation navi = new Navigation("LEFT<=RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("<=", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition04() {
		Navigation navi = new Navigation("LEFT>RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals(">", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition05() {
		Navigation navi = new Navigation("LEFT>=RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals(">=", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void perseCondition06() {
		Navigation navi = new Navigation("LEFT!=RIGHT", "NEXTTO");
		assertEquals("LEFT", navi.getLeft());
		assertEquals("!=", navi.getExpr());
		assertEquals("RIGHT", navi.getRight());
		assertEquals("NEXTTO", navi.getNextTo());	
	}
	
	@Test
	public void evaluateConditionBoolean01() {
		Navigation navi = new Navigation("LEFT==true", "NEXTTO");
		assertEquals(true, navi.evaluate(new Boolean(true)));
		assertEquals(false, navi.evaluate(new Boolean(false)));
	}
	
	@Test
	public void evaluateConditionBoolean02() {
		Navigation navi = new Navigation("LEFT!=false", "NEXTTO");
		assertEquals(true, navi.evaluate(new Boolean(true)));
		assertEquals(false, navi.evaluate(new Boolean(false)));
	}
	
	@Test
	public void evaluateConditionBoolean03() {
		Navigation navi = new Navigation("LEFT==false", "NEXTTO");
		assertEquals(true, navi.evaluate(new Boolean(false)));
		assertEquals(false, navi.evaluate(new Boolean(true)));
	}
	
	@Test
	public void evaluateConditionBoolean04() {
		Navigation navi = new Navigation("LEFT!=true", "NEXTTO");
		assertEquals(true, navi.evaluate(new Boolean(false)));
		assertEquals(false, navi.evaluate(new Boolean(true)));
	}
	
	@Test
	public void evaluateConditionString01() {
		Navigation navi = new Navigation("LEFT==hoge", "NEXTTO");
		assertEquals(true, navi.evaluate("hoge"));
		assertEquals(false, navi.evaluate("bar"));
	}
	
	@Test
	public void evaluateConditionString02() {
		Navigation navi = new Navigation("LEFT!=hoge", "NEXTTO");
		assertEquals(false, navi.evaluate("hoge"));
		assertEquals(true, navi.evaluate("bar"));
	}
	
	
}
