package org.arefgard.container.trans;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.arefgard.business.domain.action.LoginForm;
import org.junit.Test;


public class StructureTransformerTest {

	@Test
	public void transformOneToOne() {
		LoginForm login = new LoginForm();
		login.setId("00001");
		login.setPassword("p@ssw0rd");
		String customerId = null;
		String password = null;
		try {
			StructureTransformer trans = new StructureTransformer("files/test03/transform.xml");
			trans.addComponent("loginForm", login);
			
			customerId = (String)trans.transform("customerId");
			password = (String)trans.transform("password");
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
		try {
			assertEquals("00001", customerId);
			assertEquals("p@ssw0rd", password);
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	/*
	@Test
	public void transformOneToMany() {
		EntryForm entry = new EntryForm();
		entry.setFirstName("test");
		entry.setLastName("taro");
		entry.setZipCode("000-0000");
		entry.setAddress("hoge");
		Object obj1 = null;
		Object obj2 = null;
		try {
			StructureTransformer trans = new StructureTransformer("files/test03/transform.xml");
			trans.addComponent("entryForm", entry);
			
			trans.transform();
			
			obj1 = trans.getComponent("user");
			obj2 = trans.getComponent("address");
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
		try {
			System.out.println(obj1);
			assertEquals(true, obj1 instanceof org.arefgard.business.domain.model.User);
			assertEquals(entry.getFirstName(), new MethodInvocation(obj1).getProperty("firstName"));
			assertEquals(entry.getLastName(), new MethodInvocation(obj1).getProperty("lastName"));
			assertEquals(true, obj2 instanceof org.arefgard.business.domain.model.Address);
			assertEquals(entry.getZipCode(), new MethodInvocation(obj2).getProperty("zipCode"));
			assertEquals(entry.getAddress(), new MethodInvocation(obj2).getProperty("address"));
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void transformManyToOne() {
		
	}
	
	@Test
	public void transformManyToMany() {
		
	}
	*/
}
