/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.core;

import org.arefgard.container.core.BeanEntity;
import org.arefgard.container.core.IceryaContainer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BeanHandler
implements ContentHandler {
    private static final String NODE_BEAN = "bean";
    private static final String NODE_PROPERTY = "property";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_NAME = "name";
    private String nowBean;
    private String nowProperty;
    private IceryaContainer container;

    public BeanHandler(IceryaContainer container) {
        this.container = container;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nowBean != null && this.nowProperty != null) {
            BeanEntity now = this.container.getBeanEntity(this.nowBean);
            now.addProperty(this.nowProperty, new String(ch, start, length).trim());
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(NODE_BEAN)) {
            this.nowBean = null;
        } else if (qName.equals(NODE_PROPERTY)) {
            this.nowProperty = null;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(NODE_BEAN)) {
            BeanEntity beanEntity = new BeanEntity();
            beanEntity.setBeanId(atts.getValue(ATTR_ID));
            beanEntity.setBeanClass(atts.getValue(ATTR_CLASS));
            this.nowBean = beanEntity.getBeanId();
            this.container.addBeanEntity(beanEntity);
        } else if (qName.equals(NODE_PROPERTY)) {
            this.nowProperty = atts.getValue(ATTR_NAME);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

