package org.arefgard.container.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * XMLŒ`ꂽBean`t@Cp[XB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class XmlBeanDefinitionReader {
	
	/** p[Xi[DIRei */
	private IceryaContainer container;
	
	/**
	 * RXgN^B
	 * 
	 * @param container p[Xi[DIRei
	 */
	public XmlBeanDefinitionReader(IceryaContainer container) {
		this.container = container;
	}
	
	/**
	 * Bean`t@Cp[XB
	 * 
	 * @param path Bean`t@C̃pX
	 * @throws ContainerException Bean`t@C̃p[XɎsꍇ
	 */
	public void parse(String path) throws ContainerException {
		
		// SAXp[T̎擾
		XMLReader reader = null;
		try {
			reader = XMLReaderFactory.createXMLReader();
		} catch (SAXException e) {
			e.printStackTrace();
			throw new BeanDefinitionParseException("Creation XMLReader failed.", e);
		}
		
		// nh̐ݒ
		reader.setContentHandler(new BeanHandler(container));
		InputStream is = ClassLoader.getSystemResourceAsStream(path);
		if(is == null) {
			is = this.getClass().getClassLoader().getResourceAsStream(path);
		}

		try {
			reader.parse(new InputSource(is));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
		} catch (IOException e) {
			e.printStackTrace();
			throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
		} catch (SAXException e) {
			e.printStackTrace();
			throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
		}finally {
			try {
				if(is != null) {
					is.close();
				}
			}catch(Exception ignored) {}
		}
	}
}
